<?php
/**
 * @package    pixelcms_articles
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */


use Joomla\Registry\Registry;

defined('_JEXEC') or die;

require_once 'BaseModel.php';

/**
 * Pixelcms_articles model.
 *
 * @package  pixelcms_articles
 * @since    1.0
 */
class Pixelcms_articlesModelPixelcms_articles extends BaseModel
{
    protected $api_endpoint;
    protected $module;
    protected $articleId;
    protected $category_id;
    protected $cms_url;
    protected $alias;
    protected $filter;
    protected $api_version;
	protected $state;
	protected $limit;

	protected $defaults = [
		'cut_images' => 1,
		'image_fallback' => 1,
        'disable_title_image' => 0,
        'show_date' => 'before',
        'intro_length' => 200,
	];

    public function __construct(array $config = array())
    {
        $app = JFactory::getApplication();
        $this->input = $jinput = $app->input;
	    $this->limit = $jinput->getInt('limit', null);
        $this->articleId = $jinput->get('articleId', null);
        $this->category_id = $jinput->getInt('pixelcms_category_id', null);
        $this->filter = $jinput->get('pixelcms_filter', 'active');
        $this->alias = JFactory::getApplication()->get('pixel_cms_alias');
        $this->cms_url = JFactory::getApplication()->get('pixel_cms_url');
        $this->api_version = JFactory::getApplication()->get('pixel_cms_version');
        $this->api_endpoint = 'articles';
        $this->module = "pixelcms_articles";
        parent::__construct($config);
    }

    public function getArticle()
    {
        $data = $this->getCachedData('articles');
        if ($this->articleId) {
        	if (is_array($this->articleId)) {
        		if (in_array("", $this->articleId)) return $data;
		        return array_filter($data, function ($article) {
			        return in_array($article->id, $this->articleId);
		        });
	        }
            return array_reduce($data, function ($carry, $article) {
                if ($article->id === (int) $this->articleId) {
                    $carry = $article;
                }
                return $carry;
            });
        }
        return $data;
    }

    public function getCategory()
    {
        $data = $this->getCachedData('categories');
        if ($this->category_id) {
            return array_reduce($data, function ($carry, $category) {
                if ($category->id === $this->category_id) {
                    $carry = $category;
                }
                return $carry;
            });
        }
        return $data;
    }

    public function getCachedData($type)
    {
        if ($type === 'articles') {
        	$category = (is_array($this->category_id)) ? implode(',', $this->category_id) : $this->category_id;
        	$articles = (is_array($this->articleId)) ? implode(',', $this->articleId) : $this->articleId;
	        $cacheKey = "$this->api_endpoint:" . (($articles) ? "id:$articles" : "l:$this->limit;c:$category;f:$this->filter");
            $articles = $this->cache->get($cacheKey);

            if (empty($articles)) {
                $articles = $this->getData();
                $this->cache->store($articles, $cacheKey, $this->module);
            }

            return json_decode($articles);
        }
        $categories = $this->cache->get('categories', $this->module);

        if (empty($categories)) {
            $categories = $this->getCategories();
            $this->cache->store($categories, 'categories', $this->module);
        }

        return json_decode($categories);
    }

    private function getData()
    {
        $parameters = [];

        if ($this->category_id) {
            $parameters['category'] = $this->category_id;
        }

	    if ($this->limit > 0) {
		    $parameters['limit'] = $this->limit;
	    }

        $url = $this->cms_url . '/api/' . $this->api_version . '/' . "$this->api_endpoint/$this->filter";

        if ($this->filter === 'all') {
            $url = $this->cms_url . '/api/' . $this->api_version . '/' . "$this->api_endpoint";
        }

        return $this->cURL($url, $parameters);
    }

    private function getCategories()
    {
        $parameters = [];

        $url = $this->cms_url . '/api/' . $this->api_version . '/' . "categories";

        return $this->cURL($url, $parameters);
    }
}
