<?php
/**
 * @package    pixelcms_articles
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

use Joomla\Registry\Registry;

defined('_JEXEC') or die;

class BaseModel extends JModelLegacy
{
	protected $query;
	protected $input;
	protected $cache;
	protected $params;
	protected $defaults = [];
    protected static $timeout = 10;

	public function __construct(array $config = array())
	{
		$this->cache = new JCache([]);
		$this->cache->setCaching(JFactory::getApplication()->get('pixel_cms_cache', true));

		parent::__construct($config);
	}

	protected function populateState()
	{
		$app = JFactory::getApplication('site');

		// Load the parameters.
		$params = $app->getParams();
        $query = $this->getQuery();
        $input = ($this->input) ? $this->input->getArray() : [];

        $this->params = $params = new Registry(self::mergeStates([], $params->toArray(), $query->toArray(), $input));

		$this->setState('params', $params);
	}

    private static function mergeStates(...$states)
    {
        $states = array_map(function($state) {
            return array_filter($state, function($stateValue) {
                return $stateValue !== null;
            });
        }, $states);
        return array_merge(...$states);
	}

	private function getQuery()
	{
		$app = JFactory::getApplication('site');

		if (!$this->query)
		{
		    if ($this->input && $Itemid = $this->input->getInt('Itemid')) {
                $this->query = new Registry(array_merge([], $this->defaults, $app->getMenu()->getItem($Itemid)->query));
            } else {
                $this->query = new Registry(array_merge([], $this->defaults, $app->getMenu()->getActive()->query));
            }
        }

		return $this->query;
	}

    protected function cURL($url, $parameters = [])
    {
        $api_token = JFactory::getApplication()->get('pixel_cms_token');

        $parameters = array_merge([
            'api_token'=> $api_token,
        ], $parameters);

        $query = http_build_query($parameters);

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "$url?$query",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => self::$timeout,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_POSTFIELDS => "",
            CURLOPT_HTTPHEADER => array(
                "accept: application/json"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        $errNo = curl_errno($curl);

        curl_close($curl);

        if ($err) {
            throw new Exception($err, $errNo);
        }
        return $response;
    }
}
