<?php
/**
 * @package    pixelcms_articles
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */


defined('_JEXEC') or die;

require_once 'BaseModel.php';

/**
 * Pixelcms_articles model.
 *
 * @package  pixelcms_articles
 * @since    1.0
 */
class Pixelcms_articlesModelPixelcms_testimonials extends BaseModel
{
    protected $api_endpoint;
    protected $module;
    protected $cms_url;
    protected $api_version;

    public function __construct(array $config = array())
    {
        $app = JFactory::getApplication();
        $this->input = $jinput = $app->input;
        $this->cms_url = JFactory::getApplication()->get('pixel_cms_url');
        $this->api_version = JFactory::getApplication()->get('pixel_cms_version');
        $this->api_endpoint = 'testimonials';
        $this->module = "pixelcms_testimonials";
        parent::__construct($config);
    }

    public function getTestimonials()
    {
        $testimonials = $this->cache->get($this->api_endpoint, $this->module);

        if (empty($testimonials)) {
            $testimonials = $this->getData();
            $this->cache->store($testimonials, $this->api_endpoint, $this->module);
        }

        return json_decode($testimonials);
    }

    private function getData()
    {
        $parameters = [];

        $url = $this->cms_url . '/api/' . $this->api_version . '/' . "$this->api_endpoint";

        return $this->cURL($url, $parameters);
    }
}
