<?php
/**
 * @package    pixelcms_articles
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */


defined('_JEXEC') or die;

require_once 'BaseModel.php';

/**
 * Pixelcms_articles model.
 *
 * @package  pixelcms_articles
 * @since    1.0
 */
class Pixelcms_articlesModelPixelcms_teams extends BaseModel
{
    protected $api_endpoint;
    protected $module;
    protected $articleId;
    protected $category_id;
    protected $cms_url;
    protected $alias;
    protected $filter;
    protected $api_version;

    public function __construct(array $config = array())
    {
        $app = JFactory::getApplication();
        $jinput = $app->input;
        $this->articleId = $jinput->getInt('articleId', null);
        $this->alias = JFactory::getApplication()->get('pixel_cms_alias');
        $this->cms_url = JFactory::getApplication()->get('pixel_cms_url');
        $this->api_version = JFactory::getApplication()->get('pixel_cms_version');
        $this->api_endpoint = 'departments';
        $this->module = "pixelcms_departments";
        parent::__construct($config);
    }

    public function getTeam()
    {
        $data = $this->getCachedData();
        if ($this->articleId) {
	        foreach ($data->workers as $worker) {
		        $worker->email = str_rot13("$worker->email");
	        }
        } else {
		    foreach ($data as $team) {
	            foreach ($team->workers as $worker) {
	               $worker->email = str_rot13("$worker->email");
	            }
	        }
        }
        return $data;
    }

    public function getCachedData()
    {
        $articles = $this->cache->get($this->api_endpoint.$this->articleId, $this->module);

        if (empty($articles)) {
            $articles = $this->getData();
            $this->cache->store($articles, $this->api_endpoint.$this->articleId, $this->module);
        }

        return json_decode($articles);
    }

    private function getData()
    {
        $parameters = [];

        $url = $this->cms_url . '/api/' . $this->api_version . '/' . "$this->api_endpoint";
        if ($this->articleId) {
            $url = $this->cms_url . '/api/' . $this->api_version . '/' . "$this->api_endpoint/$this->articleId";
        }

        return $this->cURL($url, $parameters);
    }
}
