<?php

if (!isset($testimonial)) {
    $testimonial = $this->testimonials;
}

$html[] = '<div class="testimonial">';
$html[] = "<div class='testimonial__content'>$testimonial->content</div>";
$html[] = '<div class="testimonial__source">';
if ($testimonial->author) {
    $html[] = '<div class="testimonial__source__author">';
    if ($testimonial->author_image) {
        $thumb = $this->getThumbnail($testimonial->author_image->url, 128, true);
        $html[] = "<img src='https://cms.pixel-kraft.de{$thumb}'>";
    }
    $html[] = "<span class='testimonial__source__author__name'>$testimonial->author</span>";
    $html[] = '</div>';
}
if ($testimonial->company) {
    $html[] = '<div class="testimonial__source__company">';
    if ($testimonial->logo) {
        $thumb = $this->getThumbnail($testimonial->logo->url, 128, true);
        $html[] = "<img src='https://cms.pixel-kraft.de{$thumb}'>";
    }
    $html[] = "<span class='testimonial__source__company__name'>$testimonial->company</span>";
    $html[] = '</div>';
}
$html[] = '</div>';
$html[] = '</div>';

echo implode("\n", $html);
