<?php
    $CMS_URL = 'https://cms.pixel-kraft.de';

    $html[] = ($this->params->get('show_page_heading')) ? "<div class=\"page-header\"><h2 itemprop=\"headline\">{$this->params->get('page_title')}</h2></div>" : "";

    foreach ($this->content as $event) {
        $html[] = "<div class='cms_article'>";
        $link = JRoute::_("index.php?option=com_pixelcms_articles&view=pixelcms_events&articleId=$event->id&Itemid=$this->item_id");
	    if ($event->image) {
	        $html[] = "<a href='$link' class='cms_article__image' style='background-image: url({$this->cms_url}{$event->image->url})'></a>";
        } else {
	        $html[] = "<div class='cms_article__image cms_article__image--empty'></div>";
        }
        $html[] = "<div>";

        $html[] = "<span class='cms_article__date'>";
        if ($event->fullday) {
	        $html[] = "<strong>Am:</strong> {$this->formatDate($event->start_at, false)}";
        } else if ($event->end_at) {
	        $html[] = "<strong>Von:</strong> {$this->formatDate($event->start_at)} <strong>Bis:</strong> {$this->formatDate($event->end_at)}";
        } else {
	        $html[] = "<strong>Ab:</strong> {$this->formatDate($event->start_at)}";
        }
        $html[] = '</span>';
        $html[] = "<a href='$link'><h2 class='cms_article__headline'>$event->title</h2></a>";

        $intro_text = substr($event->description, 0, $this->intro_length);

        if (strlen($intro_text) < strlen($event->description)) {
            $intro_text .= '…';
        }

        $html[] = "<p class='cms_article__intro'>$intro_text</p>";
        $html[] = "<a class=\"cms_article__readmore\" href=\"$link\">Weiterlesen</a>";
        $html[] = "</div>";
        $html[] = "</div>";
    }
    if (!$this->content) {
        $html[] = '&nbsp;'; // Fix empty joomla modules
    }

    echo implode("\n", $html);
