<?php
$doc = JFactory::getDocument();

JHtml::_('jquery.framework');

$doc->addScript( JUri::base(true) . '/media/com_pixelcms_articles/js/jquery.colorbox-min.js' );
$doc->addStyleSheet( JUri::base(true) . '/media/com_pixelcms_articles/css/colorbox.css' );

$script = "
	jQuery( document ).ready(function() {
		jQuery('.article a.js-img').colorbox({
			rel:'gal',
			scrolling: false,
			maxHeight: '80%',
			maxWidth: '80%',
			fixed: true,
			className: 'droppics'
		});
	});
";
$doc->addScriptDeclaration( $script );

$html[] = "<div class='article'>";
$html[] = "<div class='article_left'>";
if ($this->params->get('show_page_heading')) {
    $html[] = "<h1 class='article__headline'>{$this->article->title}</h1>";
}
$html[] = "<div class='article__content'>";
if ($this->article->images) {
	$html[] = "<div class='article__images'>";
	foreach ($this->article->images as $key => $image) {
		$preview = $this->getThumbnail($image->url, 1600, false);
		if (in_array((int) $this->params->get('cut_images'), [1, 3])) {
			$thumb = $this->getThumbnail($image->url);
			$html[] = "<a href='{$this->cms_url}{$preview}' class='js-img img' style='background-image: url({$this->cms_url}{$thumb})'></a>";
		} else {
			$thumb = $this->getThumbnail($image->url, 500, false);
			$html[] = "<a class='js-img' href='{$this->cms_url}{$preview}'><img src='{$this->cms_url}{$thumb}'></a>";
		}
	}
	$html[] = "</div>";
}
$html[] = "<div class='article__content__text'>{$this->article->content}</div>";
$html[] = "</div>";
$html[] = $this->displayAttachment($this->article, 'videos');
$html[] = $this->displayAttachment($this->article, 'galleries');
$html[] = $this->displayAttachment($this->article, 'departments');
$html[] = "</div>";

if ($this->hasSidebar()) {
    $html[] = "<div class='article_right'>";
    if ($this->hasAttachment('workers')) {
        $html[] = "<h3>Ansprechpartner</h3>";
        $html[] = $this->displayAttachment($this->article, 'workers');
    }
    if ($this->hasAttachment('pdfs')) {
        $html[] = "<h3>PDFs</h3>";
        $html[] = $this->displayAttachment($this->article, 'pdfs');
    }
    if ($this->hasAttachment('files')) {
        $html[] = "<h3>Dateien</h3>";
        $html[] = $this->displayAttachment($this->article, 'files');
    }
    $html[] = "</div>";
}

$html[] = "</div>";
$html[] = $this->attachPlayerScripts();


echo implode("\n", $html);
