<?php
$document = JFactory::getDocument();
$lang = JFactory::getLanguage();
$langCode = $lang->getTag();
$langCodeShort = substr($langCode, 0, 2);

$uid = bin2hex(random_bytes(10));

$script = "
'use strict';

document.addEventListener('DOMContentLoaded', function (event) {
	var app = new Vue({
		el: '#app-$uid',
		data: {
			pageSize: {$this->params->get('page_size', 15)},
			currentPage: 1,
			priceStyle: {$this->params->get('price_style', 0)},
			products: ". json_encode($this->ads) .",
			filters: {
				manufacturer: false,
				category: false,
				age: false
			},
            sortKey: 'id',
			sortOrders: {
				id: 1,
				year: 1,
				price: 1,
                workhours: 1,
                trade_price: 1,
                power: 1,
			},
		},
		methods: {
		    setURL: function setURL() {
		        var obj = {p: this.currentPage, s: {k: this.sortKey, o: this.sortOrders[this.sortKey]}, f: {m: this.filters.manufacturer, c: this.filters.category}};
		        window.location.hash = '!' + encodeURI(btoa(JSON.stringify(obj)))
		    },
		    saveURL: function saveURL() {
		        window.sessionStorage.setItem('product_link', window.location.href);
		    },
		    parseURL: function parseURL() {
		        var _this = this;
		        var hash = window.location.hash.substr(2);
		        if (hash) {
		            try {
		                var obj = JSON.parse(atob(decodeURI(hash)));
		                this.filters.manufacturer = obj.f.m;
		                this.filters.category = obj.f.c;
		                
		                this.sortKey= obj.s.k;
		                this.sortOrders[this.sortKey]= obj.s.o;
		                
		                this.\$nextTick(function() {
		                    _this.setPage(obj.p);
		                });
		            } catch (err) {
		                console.log(err);
		            }
		        }
		    },
			setPage: function setPage(page) {
				this.currentPage = Math.max(1, Math.min(page, this.pages));
				
				var menu = document.getElementById('menu-container');
				var menuHeight = menu ? menu.clientHeight : 0;
				
				window.scrollBy({
					top: this.\$refs.topPagination.getBoundingClientRect().y - menuHeight - parseInt(getComputedStyle(this.\$refs.topPagination).marginTop, 10), 
					behavior: 'smooth'
				});
			}
		},
		created: function created() {
		    this.parseURL();
		},
		computed: {
			pages: function pages() {
				return Math.ceil(this.filteredData.length / this.pageSize);
			},
			paginatedData: function paginatedData() {
			    this.setURL();
				return this.filteredData.slice((this.currentPage - 1) * this.pageSize, this.currentPage * this.pageSize);
			},
			filteredData: function filteredData() {
				var _this = this;
				var sortKey = this.sortKey;
				var order = this.sortOrders[sortKey] || 1;
				var filtered = this.products;
				
				this.currentPage = 1;

				if (this.filters.manufacturer !== false) {
					filtered = filtered.filter(function (value) {
						return value.manufacturer.id == _this.filters.manufacturer;
					});
				}
				if (this.filters.category !== false) {
					filtered = filtered.filter(function (value) {
						return value.category.id == _this.filters.category;
					});
				}
				if (this.filters.age !== false) {
					var date = new Date();
					filtered = filtered.filter(function (value) {
						return date.getFullYear() - value.year <= _this.filters.age;
					});
				}
				
				filtered = filtered.sort(function(a,b) {
				    if (['price', 'workhours', 'trade_price', 'power'].includes(sortKey)) {
				        return Math.sign(((b[sortKey]) ? b[sortKey].value : -1) - ((a[sortKey]) ? a[sortKey].value : -1)) * order;
				    }
				    return Math.sign(b[sortKey] - a[sortKey]) * order;
				});

				return filtered;
			},
			manufacturers: function manufacturers() {
				var _this2 = this;

				var manufacturers = [];
				var filtered = this.products;

				if (this.filters.category !== false) {
					filtered = filtered.filter(function (value) {
						return value.category.id == _this2.filters.category;
					});
				}
				if (this.filters.age !== false) {
					var date = new Date();
					filtered = filtered.filter(function (value) {
						return date.getFullYear() - value.year <= _this2.filters.age;
					});
				}

				filtered.forEach(function (val, index) {
					manufacturers[val.manufacturer.id] = val.manufacturer;
				});
				
                return manufacturers.filter(function(a){
                    return a;
                }).sort(function(a,b) {
                    if(a.id === 0) return -1; else if(b.id === 0) return 1;
				    return a.value.localeCompare(b.value)
				});
			},
			categories: function categories() {
				var _this3 = this;

				var categories = [];
				var filtered = this.products;

				if (this.filters.manufacturer !== false) {
					filtered = filtered.filter(function (value) {
						return value.manufacturer.id == _this3.filters.manufacturer;
					});
				}
				if (this.filters.age !== false) {
					var date = new Date();
					filtered = filtered.filter(function (value) {
						return date.getFullYear() - value.year <= _this3.filters.age;
					});
				}

				filtered.forEach(function (val, index) {
					categories[val.category.id] = val.category;
				});
				
                return categories.filter(function(a){
                    return a;
                }).sort(function(a,b) {
				    return a.name.localeCompare(b.name);
				});
			},
			ages: function ages() {
				var _this4 = this;

				var ages = {};
				var filtered = this.products;
				var date = new Date();

				if (this.filters.manufacturer !== false) {
					filtered = filtered.filter(function (value) {
						return value.manufacturer.id == _this4.filters.manufacturer;
					});
				}
				if (this.filters.category !== false) {
					filtered = filtered.filter(function (value) {
						return value.category.id == _this4.filters.category;
					});
				}
				if (this.filters.age !== false) {
					ages[this.filters.age] = {
						value: this.filters.age,
						id: this.filters.age
					};
				}

				filtered.forEach(function (value, index) {
					var age = date.getFullYear() - value.year;
					ages[age] = {
						value: age,
						id: age,
					};
				});
				return ages;
			}
		}
	});
});
";

$document->addScriptDeclaration( $script );

?>
<?php if ($this->params->get('show_page_heading')): ?>
    <h2><?php echo $this->title; ?></h2>
<?php endif; ?>
<div id="app-<?php echo $uid ?>">
    <div class="filter">
        <div class="select-group">
            <label for="sortKey"><?php echo JText::_( 'COM_PIXELCMS_SORTKEY_LABEL' ) ?></label>
            <select id="sortKey" v-model="sortKey">
                <option value="id"><?php echo JText::_( 'COM_PIXELCMS_SORTKEY_DEFAULT' ) ?></option>
                <option value="year"><?php echo JText::_( 'COM_PIXELCMS_SORTKEY_YEAR' ) ?></option>
                <option value="price"><?php echo JText::_( 'COM_PIXELCMS_SORTKEY_PRICE' ) ?></option>
            </select>
        </div>
        <div class="select-group">
            <label for="sortOrder"><?php echo JText::_( 'COM_PIXELCMS_SORTORDER_LABEL' ) ?></label>
            <select :disabled="sortKey === 'id'" v-model="sortOrders[sortKey]" id="sortOrder">
                <option :value="-1"><?php echo JText::_( 'COM_PIXELCMS_SORTORDER_ASC' ) ?></option>
                <option :value="1"><?php echo JText::_( 'COM_PIXELCMS_SORTORDER_DESC' ) ?></option>
            </select>
        </div>
        <div class="select-group">
            <label for="filterCategory"><?php echo JText::_( 'COM_PIXELCMS_SELECT_CATEGORY_LABEL' ) ?></label>
            <select v-model="filters.category" id="filterCategory">
                <option :value="false" selected><?php echo JText::_( 'COM_PIXELCMS_SELECT_CATEGORY' ) ?></option>
                <option :value="item.id" v-for="item in categories">{{ item.name }}</option>
            </select>
        </div>
        <div class="select-group">
            <label for="filterManufacturer"><?php echo JText::_( 'COM_PIXELCMS_SELECT_MANUFACTURER_LABEL' ) ?></label>
            <select v-model="filters.manufacturer" id="filterManufacturer">
                <option :value="false" selected><?php echo JText::_( 'COM_PIXELCMS_SELECT_MANUFACTURER' ) ?></option>
                <option :value="item.id" v-for="item in manufacturers">{{ item.value }}</option>
            </select>
        </div>
        <!-- 		<select v-model="filters.age" placeholder="Alter">
			<option :value="false" selected><?php echo $locale->select_age ?></option>
			<option :value="item.id" v-for="item in ages"><?php echo $locale->newer_than ?></option>
		</select> -->
        <div class="filter__result_text">
            <span v-if="filteredData.length == 1"><?php echo JText::_( 'COM_PIXELCMS_ITEM_1' ) ?></span>
            <span v-else><?php echo JText::_( 'COM_PIXELCMS_ITEM_2' ) ?></span>
        </div>
    </div>
    <div  class="pagination" v-if="(pages > 1)" ref="topPagination">
        <ul>
            <li @click="setPage(currentPage - 1)" :class="{ disabled: (currentPage == 1) }"><?php echo JText::_( 'COM_PIXELCMS_PREV_PAGE' ) ?></li>
            <li @click="setPage(page)" v-for="page in pages" :class="{ active: (page == currentPage) }">{{ page }}</li>
            <li @click="setPage(currentPage + 1)" :class="{ disabled: (currentPage == pages) }"><?php echo JText::_( 'COM_PIXELCMS_NEXT_PAGE' ) ?></li>
        </ul>
    </div>
    <div class="custom ads">
        <div class="ad" :class="{'ad--offer': product.offer}" v-for="(product, index) in paginatedData">
            <a @click="saveURL" class="ad__image" :class="{'ad__image--empty': product.images.length === 0}" :href="product.link">
                <div v-if="product.images[0]" class="ad__image__wrapper" :style="{ backgroundImage: 'url(\'' + ((product.images[0]) ? product.images[0].href + '?width=500&quality=90' : '') + '\')' }"></div>
                <div v-else class="ad__image__wrapper ad__image__wrapper--empty"></div>
				<div class="ad__price" v-if="product.price.values">
                    <div v-if="[0,1,3,4].includes(priceStyle)">
						<span v-if="[0,1].includes(priceStyle)"><?php echo JText::_( 'COM_PIXELCMS_NETTO' ) ?></span><span v-else><?php echo JText::_( 'COM_PIXELCMS_NETTO_SHORT' ) ?></span><del v-if="product.offer">{{product.price.values.old.toLocaleString('de-DE', { style: 'currency', currency: 'EUR',currencyDisplay: 'code', minimumFractionDigits:0, maximumFractionDigits: 0 }) }}<br /></del>{{product.price.values.netto.toLocaleString('de-DE', { style: 'currency', currency: 'EUR',currencyDisplay: 'code', minimumFractionDigits:0, maximumFractionDigits: 0 }) }}
                    </div>
                    <div v-if="[0,2,3,5].includes(priceStyle) && product.vat.value">
                        <span v-if="[0,2].includes(priceStyle)"><?php echo JText::_( 'COM_PIXELCMS_BRUTTO' ) ?></span><span v-else><?php echo JText::_( 'COM_PIXELCMS_BRUTTO_SHORT' ) ?></span> {{product.price.values.brutto.toLocaleString('de-DE', { style: 'currency', currency: 'EUR',currencyDisplay: 'code', minimumFractionDigits:0, maximumFractionDigits: 0 }) }}
                    </div>
                </div>
                <div class="ad__price" v-else><?php echo JText::_( 'COM_PIXELCMS_ASK_FOR_PRICE' ) ?></div>
            </a>
            <h3><span v-if="product.manufacturer">{{product.manufacturer.value}}</span> <span v-if="product.model">{{product.model}}</span></h3>
            <div v-if="product.year"><?php echo JText::_( 'COM_PIXELCMS_BUILD_YEAR' ) ?>: {{product.year}}</div>
            <div v-if="product.power"><?php echo JText::_( 'COM_PIXELCMS_POWER' ) ?>: {{product.power.kW}} kw ({{product.power.PS}} PS)</div>
            <div v-if="product.workhours"><?php echo JText::_( 'COM_PIXELCMS_WORKHOURS' ) ?>: {{product.workhours.show}}</div>
            <div v-if="!product.workhours && !product.power && !product.year" class="layout-spacer"></div>
            <a @click="saveURL" class="ad__button" :href="product.link"><?php echo JText::_( 'COM_PIXELCMS_READ_MORE' ) ?></a>
        </div>
        <div v-if="paginatedData.length == 0" class="ad__empty">
            Leider ergab Ihre Suche keinen Treffer.
        </div>
    </div>
    <div class="pagination" v-if="(pages > 1)">
        <ul>
            <li @click="setPage(currentPage - 1)" :class="{ disabled: (currentPage == 1) }"><?php echo JText::_( 'COM_PIXELCMS_PREV_PAGE' ) ?></li>
            <li @click="setPage(page)" v-for="page in pages" :class="{ active: (page == currentPage) }">{{ page }}</li>
            <li @click="setPage(currentPage + 1)" :class="{ disabled: (currentPage == pages) }"><?php echo JText::_( 'COM_PIXELCMS_NEXT_PAGE' ) ?></li>
        </ul>
    </div>
</div>
<div class="traktorpool-copyright">
    Ein Service von <a target="_blank" href="<?php echo "https://www.traktorpool.de/{$this->params->get('tracktorpool_alias', '')}/" ?>"><img src="https://www.traktorpool.de/images/frontend/de/logo.svg" alt="Traktorpool"></a>
</div>
