<?php
/**
 * @package    pixelcms_articles
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

defined('_JEXEC') or die;

/**
 * Pixelcms_articles view.
 *
 * @package  pixelcms_articles
 * @since    1.0
 */
class Pixelcms_articlesViewPixelcms_teams extends JViewLegacy
{
    protected $team;
    protected $articleId;
    protected $cms_url;
    protected $alias;
    protected $params;
    protected $title;
    protected $workers_per_row = 4;
    protected $single = true;

    static $attachments = [
        'galleries' => 'gallery',
        'workers' => 'worker',
        'pdfs' => 'pdf',
        'files' => 'file',
        'videos' => 'video',
        'images' => 'image',
        'locations' => 'location',
        'departments' => 'department',
    ];

    public function __construct(array $config = array())
    {
        $this->alias = JFactory::getApplication()->get('pixel_cms_alias');
        $this->cms_url = JFactory::getApplication()->get('pixel_cms_url');
	    $app = JFactory::getApplication();
	    $this->title = $app->getMenu()->getActive()->title;
        $this->workers_per_row = 4;
        parent::__construct($config);
    }

	public function displayWorker($worker)
	{
		//$html[] =  "<pre>". print_r($worker, true) ."</pre>";
		if ($worker->image) {
			$thumb = preg_replace('/(^(?!http)(?:(?!thumb).)*)\.(jpe?g|png|gif)/', '$1.500-cropped.$2', $worker->image->url);
			$html[] = "<div class='worker__image' style='background-image: url({$this->cms_url}{$thumb})'></div>";
		} else {
			$gender = ($worker->title === 2) ? 'female' : 'male';
			$html[] = "<div class='worker__image worker__image--empty worker__image--empty--$gender'></div>";
		}
		$html[] = "<h4 class='worker__title'>$worker->first_name $worker->last_name</h4>";
		if (isset($worker->role)) {
			$html[] = "<span class=\"worker__role\">$worker->role</span>";
		}
		$html[] = "<ul class=\"worker__contact\">";
		if ($worker->email) {
			$html[] = "<li><a class='emails--encrypted' href=\"mailto:$worker->email\"><i class=\"material-icons\">email</i><span>$worker->email</span></a></li>";
		}
		if ($worker->tel) {
			$telNumber = $this->getCallablePhone($worker->tel);
			$displayNumber = $this->getDisplayablePhone(($worker->tel));
			$html[] = "<li><a href=\"tel:$telNumber\"><i class=\"material-icons\">phone</i><span>$displayNumber</span></a></li>";
		}
		if ($worker->mobile) {
			$telNumber = $this->getCallablePhone($worker->mobile);
			$displayNumber = $this->getDisplayablePhone(($worker->mobile));
			$html[] = "<li><a href=\"tel:$telNumber\"><i class=\"material-icons\">phone_android</i><span>$displayNumber</span></a></li>";
		}
		if ($worker->fax) {
			$telNumber = $this->getCallablePhone($worker->fax);
			$displayNumber = $this->getDisplayablePhone(($worker->fax));
			$html[] = "<li><a href=\"fax:$telNumber\"><i class=\"material-icons\">print</i><span>$displayNumber</span></a></li>";
		}

		$html[] =  "</ul>";
		return implode("\n", $html);
	}

	private function getCallablePhone($phone)
	{
		return preg_replace([
			'/[\s\/\-]/',
			'/(\+\s?\d{2})(?:\s?(?:\(0\)|0)\s?)?/',
		], [
			'',
			'$1',
		], $phone);
	}

	private function getDisplayablePhone($phone)
	{
		return preg_replace([
			//'/(\d)\s(\d)/',
			'/ - /',
			// '/\+\s?\d{2}\s?(?:\s?(?:\(0\)|0)\s?)?/',
		], [
			//'$1$2',
			' ',
			// '0',
		], $phone);
	}

    public function displayDepartment($department) {
        $html[] = '<div class="department__workers">';
        foreach ($department->workers as $worker) {
	        $html[] = "<div class='worker worker--col-4 worker--col-2-phone worker--col-3-tablet'>";
            $html[] = $this->displayWorker($worker);
            $html[] = "</div>";
        }
	    $html[] = "</div>";
	    return implode("\n", $html);
    }

	function display($tpl = null)
	{
		// Assign data to the view
        $this->team = $this->get('Team');
		$this->params = $this->get('state')->get('params');

        if (gettype($this->team) === 'array') {
	        $tpl = 'listing';
        }

        $document = JFactory::getDocument();
        $document->addStyleSheet('https://fonts.googleapis.com/icon?family=Material+Icons');
        $document->addStyleSheet(JURI::base(true) . '/media/com_pixelcms_articles/css/style.css', [
            'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/css/style.css'),
        ]);
        $document->addScript(JURI::base(true) . '/media/com_pixelcms_articles/js/script.js', [
            'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/js/script.js'),
        ]);

		// Display the view
		parent::display($tpl);
	}
}
