<?php
$doc = JFactory::getDocument();

$html[] = "<div class='manufacturer-logos'>";

$logos = [];
$manufacturers = array_filter($this->manufacturers, function($manufacturer) use (&$logos){
    if ($manufacturer->image === null) {
        return false;
    }
    if (in_array($manufacturer->image, $logos)) {
        return false;
    }
    $logos[] = $manufacturer->image;
    return true;
});

 // shuffle($manufacturers);
$manufacturers = array_slice($manufacturers, 0, $this->params->get('limit', 8));

foreach ($manufacturers as $manufacturer) {
    $html[] = "<div class=\"manufacturer\" id='m-$manufacturer->id' data-manufacturer='$manufacturer->title'>";
    // $html[] = "<div class=\"manufacturer__header\" id=\"uid-$manufacturer->id\">";
    // $html[] = "<h3>$manufacturer->title</h3>";
    // $html[] = "</div>";
    if (($manufacturer->color)) {
        $html[] = "<div style='background: $manufacturer->color' class=\"manufacturer__image manufacturer__image--colored\">";
    } else {
        $html[] = "<div class=\"manufacturer__image\">";
    }
    $html[] = "<img src=\"$this->cms_url/$manufacturer->image\" width=\"160\" height=\"55\" alt=\"$manufacturer->title\" title=\"$manufacturer->title\">";
    $html[] = "</div>";
    $html[] = "</div>";
}

$html[] = "</div>";
echo implode("\n", $html);
