<?php
$doc = JFactory::getDocument();

$html[] = "<div class='manufacturer-logos'>";

$logos = [];
$manufacturers = array_filter($this->manufacturers, function($manufacturer) use (&$logos){
    if ($manufacturer->image === null) {
        return false;
    }
    if (in_array($manufacturer->image, $logos)) {
        return false;
    }
    $logos[] = $manufacturer->image;
    return true;
});

shuffle($manufacturers);
$pages = array_chunk($manufacturers, 8);

foreach ($pages as $key => $page) {
    $html[] = "<div class=\"manufacturer-page\" id='m-page-$key' data-page='$key'>";
    foreach ($page as $manufacturer) {
        $html[] = "<div class=\"manufacturer\" id='m-$manufacturer->id' data-manufacturer='$manufacturer->title'>";
        // $html[] = "<div class=\"manufacturer__header\" id=\"uid-$manufacturer->id\">";
        // $html[] = "<h3>$manufacturer->title</h3>";
        // $html[] = "</div>";
        if (($manufacturer->color)) {
            $html[] = "<div style='background: $manufacturer->color' class=\"manufacturer__image manufacturer__image--colored\">";
        } else {
            $html[] = "<div class=\"manufacturer__image\">";
        }
        $html[] = "<img src=\"$this->cms_url/$manufacturer->image\" width=\"160\" height=\"55\" alt=\"$manufacturer->title\" title=\"$manufacturer->title\">";
        $html[] = "</div>";
        $html[] = "</div>";
    }
    $html[] = "</div>";
}


$html[] = "</div>";
echo implode("\n", $html); ?>
<script>
    [].slice.call(document.querySelectorAll('.manufacturer-page')).forEach(function(el) {
        setInterval(function() {
            shuffleChildren(el);
        }, 8000);
    });

    function getRandomArbitrary(min, max) {
        return Math.random() * (max - min) + min;
    }

    function shuffleChildren(el) {
        for (var i = el.children.length; i >= 0; i--) {
            el.appendChild(el.children[Math.random() * i | 0]);
        }
    }
</script>
