<?php
/**
 * @package    pixelcms_articles
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */


use Joomla\Registry\Registry;

defined('_JEXEC') or die;

require_once 'BaseModel.php';

/**
 * Pixelcms_articles model.
 *
 * @package  pixelcms_articles
 * @since    1.0
 */
class Pixelcms_articlesModelPixelcms_manufacturers extends BaseModel
{
    protected $api_endpoint;
    protected $module;
    protected $articleId;
    protected $category_id;
    protected $cms_url;
    protected $alias;
    protected $filter;
    protected $api_version;

    protected $defaults = [
    	'limit' => 8,
    ];

    public function __construct(array $config = array())
    {
        $this->input = $jinput = JFactory::getApplication()->input;
        $this->category_id = $jinput->get('pixelcms_category_id', null);
        $this->articleId = $jinput->getInt('articleId', null);
        $this->cms_url = JFactory::getApplication()->get('pixel_cms_url');
        $this->api_version = JFactory::getApplication()->get('pixel_cms_version');
        $this->api_endpoint = 'manufacturers';
        $this->module = "pixelcms_manufacturers";
        parent::__construct($config);
    }

    public function getManufacturers()
    {
        $data = $this->getCachedData();
        if ($this->articleId) {
            return array_reduce($data, function ($carry, $article) {
                if ($article->id === $this->articleId) {
                    $carry = $article;
                }
                return $carry;
            });
        }
        return $data;
    }

    public function getCachedData()
    {
    	$cacheKey = (is_array($this->category_id)) ? implode('.', $this->category_id) : $this->category_id;
        $articles = $this->cache->get($this->api_endpoint . $cacheKey, $this->module);

        if (empty($articles)) {
            $articles = $this->getData();
            $this->cache->store($articles, $this->api_endpoint . $cacheKey, $this->module);
        }

        return json_decode($articles);
    }

    private function getData()
    {
        $parameters = [];

        if ($this->category_id) {
            $parameters['category'] = $this->category_id;
        }

        $url = $this->cms_url . '/api/' . $this->api_version . '/' . "$this->api_endpoint";

        return $this->cURL($url, $parameters);
    }

    private function cURL($url, $parameters = [])
    {
        $api_token = JFactory::getApplication()->get('pixel_cms_token');

        $parameters = array_merge([
            'api_token'=> $api_token,
        ], $parameters);

        $query = http_build_query($parameters);

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "$url?$query",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 5,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_POSTFIELDS => "",
            CURLOPT_HTTPHEADER => array(
                "accept: application/json"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        }
        return $response;
    }
}
