<?php
/**
 * @package    pixelcms_articles
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */


use Joomla\Registry\Registry;

defined('_JEXEC') or die;


require_once 'BaseModel.php';

/**
 * Pixelcms_articles model.
 *
 * @package  pixelcms_articles
 * @since    1.0
 */
class Pixelcms_articlesModelPixelcms_events extends BaseModel
{
    protected $api_endpoint;
    protected $module;
    protected $articleId;
    protected $category_id;
    protected $cms_url;
    protected $alias;
    protected $filter;
    protected $api_version;
	protected $state;
	protected $query;
	protected $defaults = [
        'disable_title_image' => 0,
    ];

    public function __construct(array $config = array())
    {
        $app = JFactory::getApplication();
        $jinput = $app->input;
        $this->articleId = $jinput->get('articleId', null);
        $this->category_id = $jinput->getInt('pixelcms_category_id', null);
        $this->filter = $jinput->get('pixelcms_filter', 'all');
        $this->alias = JFactory::getApplication()->get('pixel_cms_alias');
        $this->cms_url = JFactory::getApplication()->get('pixel_cms_url');
        $this->api_version = JFactory::getApplication()->get('pixel_cms_version');
        $this->api_endpoint = 'events';
        $this->module = "pixelcms_events";
        parent::__construct($config);
    }

	protected function populateState()
	{
		$app = JFactory::getApplication('site');

		// Load the parameters.
		$params = $app->getParams();
		$query = $this->getQuery();

		$this->setState('params', $params);
		$this->setState('options', $query);
	}

	private function getQuery()
	{
		$app = JFactory::getApplication('site');

		if (!$this->query)
		{
			$this->query = new Registry(array_merge([], $this->defaults, $app->getMenu()->getActive()->query));
		}

		return $this->query;
	}

    public function getArticle()
    {
        $data = $this->getCachedData('articles');
        if ($this->articleId) {
        	if (is_array($this->articleId)) {
        		if (in_array("", $this->articleId)) return $data;
		        return array_filter($data, function ($article) {
			        return in_array($article->id, $this->articleId);
		        });
	        }
            return array_reduce($data, function ($carry, $article) {
                if ($article->id === (int) $this->articleId) {
                    $carry = $article;
                }
                return $carry;
            });
        }
        return $data;
    }

    public function getCategory()
    {
        $data = $this->getCachedData('categories');
        if ($this->category_id) {
            return array_reduce($data, function ($carry, $category) {
                if ($category->id === $this->category_id) {
                    $carry = $category;
                }
                return $carry;
            });
        }
        return $data;
    }

    public function getCachedData($type)
    {
        if ($type === 'articles') {
            $articles = $this->cache->get($this->api_endpoint.$this->category_id.$this->filter, $this->module);

            if (empty($articles)) {
                $articles = $this->getData();
                $this->cache->store($articles, $this->api_endpoint.$this->category_id.$this->filter, $this->module);
            }

            return json_decode($articles);
        }
        $categories = $this->cache->get('categories', $this->module);

        if (empty($categories)) {
            $categories = $this->getCategories();
            $this->cache->store($categories, 'categories', $this->module);
        }

        return json_decode($categories);
    }

    private function getData()
    {
        $parameters = [];

        if ($this->category_id) {
            $parameters['category'] = $this->category_id;
        }

        $url = $this->cms_url . '/api/' . $this->api_version . '/' . "$this->api_endpoint/$this->filter";

        if ($this->filter === 'all') {
            $url = $this->cms_url . '/api/' . $this->api_version . '/' . "$this->api_endpoint";
        }

        return $this->cURL($url, $parameters);
    }

    private function getCategories()
    {
        $parameters = [];

        $url = $this->cms_url . '/api/' . $this->api_version . '/' . "categories";

        return $this->cURL($url, $parameters);
    }


    private function cURL($url, $parameters = [])
    {
        $api_token = JFactory::getApplication()->get('pixel_cms_token');
	    $parameters = array_merge([
            'api_token'=> $api_token,
        ], $parameters);

	    $query = http_build_query($parameters);

	    $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "$url?$query",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 5,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_POSTFIELDS => "",
            CURLOPT_HTTPHEADER => array(
                "accept: application/json"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            throw new Exception('Serverfehler.');
        }
        return $response;
    }
}
