<?php
/**
 * @package    pixelcms_articles
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

use Joomla\CMS\MVC\View\HtmlView;

defined('_JEXEC') or die;

enum PriceStyle: int
{
    case BOTH = 0;
    case NETTO_ONLY = 1;
    case BRUTTO_ONLY = 2;
    case BOTH_SHORT = 3;
    case NETTO_ONLY_SHORT = 4;
    case BRUTTO_ONLY_SHORT = 5;

    public function getTranslationKey()
    {
        return match ($this) {
            self::NETTO_ONLY => 'netto_only',
            self::BRUTTO_ONLY => 'brutto_only',
            self::BOTH_SHORT => 'both_short',
            self::NETTO_ONLY_SHORT => 'netto_only_short',
            self::BRUTTO_ONLY_SHORT => 'brutto_only_short',
            default => 'both',
        };
    }
}

/**
 * Pixelcms_articles view.
 *
 * @package  pixelcms_articles
 * @since    1.0
 */
class pixelcms_articlesViewtracktorpool_products extends HtmlView
{
    protected $ads;
    protected $locale;
    protected $relatedAds;
    protected $uid;
    protected $params;
    protected $teamId;
    protected $is_module = false;

	function display($tpl = null)
	{
		// Assign data to the view
        $this->ads = $this->get('Data');
        $this->locale = $this->get('Locale');
		$this->params = $this->get('state')->get('params');
        $this->uid = bin2hex(random_bytes(10));

        $lang = JFactory::getLanguage();
        $langCode = $lang->getTag();
        $langCodeShort = substr($langCode, 0, 2);

		$document = JFactory::getDocument();
		if (gettype($this->ads) === 'array') {
	        $tpl = 'listing';

            if ($this->getLayout() === 'default' && $this->params->get('next_ui', false)) {
                $this->setLayout('next');

                if ($_GET['json'] == 1) {
                    header("Content-type: application/json; charset=utf-8");
                    echo json_encode($this->ads, JSON_PRETTY_PRINT);
                    die();
                }

                $appURI = JURI::base(true) . '/media/com_pixelcms_articles/dist/pixelcms.es.js?' . md5_file(JPATH_BASE . '/media/com_pixelcms_articles/dist/pixelcms.es.js');

                $price_style = PriceStyle::tryFrom($this->params->getInt('price_style', null))->getTranslationKey();

                $script = "
                    import MachineMarketplace from '{$appURI}';

                    MachineMarketplace('#app-{$this->uid}', {
                      pageSize: {$this->params->get('page_size', 16)},
                      settings: {
                        decimals: {$this->params->getInt('decimals', 2)},
                        order: '{$this->params->get('order', null)}',
                        price_display: '{$price_style}',
                        show_price_label: {$this->params->getInt('show_price_label', true)},
                        show_icons: {$this->params->getInt('show_icons', true)},
                      },
                      lang: \"{$langCodeShort}\",
                      machines: ". json_encode($this->ads) .",
                    });
                ";

                if ($_GET['json']) {
                    header('Content-type: application/json');
                    echo json_encode($this->ads);
                    die();
                }

                $document->addStyleSheet(JURI::base(true) . '/media/com_pixelcms_articles/dist/style.css', [
                    'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/dist/style.css'),
                ]);

                $document->addScriptDeclaration( $script, 'module' );
            } else {
                $document->addScript(JURI::base(true) . '/media/com_pixelcms_articles/js/vue.min.js', [
                    'version' => '2.5.16',
                ]);
            }
        } else {
            if ($this->getLayout() === 'default' && $this->params->get('next_ui', false)) {
                $this->setLayout('next');
            }

            $this->relatedAds = $this->get('RelatedAds');

            $ad = $this->ads;
            $title = $ad->title ?? implode(' ', [$ad->manufacturer->value, $ad->model]);
            $document->setTitle($title);

            $input = JFactory::getApplication()->input;
            $input->set('px-title', $title);
            $input->set('px-art-nr', $ad->dealer_internal_id ?? $ad->id);
            $input->set('px-vehicle-condition', $ad->condition->id);

            $manufacturer = $ad->manufacturer->sub_brand ?? $ad->manufacturer->value;
            $input->set('px-manufacturer', $manufacturer);
            $input->set('px-contact-address', $this->getContactMapping($manufacturer));

            if (method_exists($ad, 'getVin')) {
                $input->set('px-vin', $ad->getVin());
            }
        }

        $document->addScript(JURI::base(true) . '/media/com_pixelcms_articles/js/cssua.min.js', [
            'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/js/cssua.min.js'),
        ]);
		$document->addStyleSheet(JURI::base(true) . '/media/com_pixelcms_articles/css/fonts.css', [
            'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/css/fonts.css'),
        ]);
        $document->addStyleSheet(JURI::base(true) . '/media/com_pixelcms_articles/css/machine_details.css', [
            'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/css/machine_details.css'),
        ]);
        $document->addStyleSheet(JURI::base(true) . '/media/com_pixelcms_articles/css/style.css', [
        	'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/css/style.css'),
        ]);
        $document->addScript(JURI::base(true) . '/media/com_pixelcms_articles/js/script.js', [
	        'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/js/script.js'),
        ]);

		// Display the view
		parent::display($tpl);
	}

    private function getContactMapping(string $manufacturer)
    {
        $config = parse_ini_string($this->params->get('maschinen_contact_mapping', ''), true);
        $config = array_change_key_case($config, CASE_UPPER);
        $config = $config[strtoupper($manufacturer)];

        $mail = $config['Mail'];
        $this->teamId = $config['Team'];

        return $mail;
    }

    public function displayTeam()
    {
        if (!$this->teamId) return '';

        $input = JFactory::getApplication()->input;

        $old_input = [
            'view' => $input->get('view'),
            'option' => $input->get('option'),
            'layout' => $input->get('layout'),
            'articleId' => $input->get('articleId', null),
            'model' => $input->get('model', null),
            'show_page_heading' => $input->get('show_page_heading'),
        ];

        $input->set('view', 'pixelcms_teams');
        $input->set('articleId', $this->teamId);
        $input->set('model', 'pixelcms_teams');
        $input->set('layout', 'default');
        $input->set('hide_contact_details', true);
        $input->set('is_module', true);
        $input->set('show_page_heading', false);

        $controller = JControllerLegacy::getInstance('pixelcms_articles');
        ob_start();
        $controller->display(false);
        $content = ob_get_clean();

        foreach ($old_input as $key => $value) {
            $input->set($key, $value);
        }

        return $content;
    }

    protected function _setPath($type, $path)
    {
        $component = 'com_pixelcms_articles';
        $app = JFactory::getApplication();

        // Clear out the prior search dirs
        $this->_path[$type] = array();

        // Actually add the user-specified directories
        $this->_addPath($type, $path);

        // Always add the fallback directories as last resort
        switch (strtolower($type))
        {
            case 'template':
                // Set the alternative template search dir
                if (isset($app))
                {
                    $component = preg_replace('/[^A-Z0-9_\.-]/i', '', $component);
                    $fallback = JPATH_THEMES . '/' . $app->getTemplate() . '/html/' . $component . '/' . $this->getName();
                    $this->_addPath('template', $fallback);
                }
                break;
        }
    }
}
