<?php
$doc = JFactory::getDocument();

$lang = JFactory::getLanguage();
$langCode = $lang->getTag();
$langCodeShort = substr($langCode, 0, 2);
$jinput = JFactory::getApplication()->input;

$model = $this->params->get('model', 'tracktorpool_products');

$locale = $this->locale;

$ad = $this->ads;

$conditions = [
    'used' => 'Gebraucht',
    'new' => 'Neu',
];

JHtml::_('jquery.framework');

$doc->addScript( JUri::base(true) . '/media/com_pixelcms_articles/js/jquery.colorbox-min.js' );
$doc->addStyleSheet( JUri::base(true) . '/media/com_pixelcms_articles/css/colorbox.css' );

$menu = JFactory::getApplication()->getMenu();
$parent = $menu->getActive();
$parentlink = JRoute::_( 'index.php?Itemid=' . $parent->id );

$title = $ad->title ?? implode(' ', [$ad->manufacturer->value, $ad->model]);

$script = "
	jQuery( document ).ready(function() {
		jQuery('.product__images__thumbs a').colorbox({
			rel:'gal',
			scrolling: false,
			maxHeight: '80%',
			maxWidth: '80%',
			fixed: true,
			className: 'droppics'
		});

        document.getElementById('back_link').addEventListener('click', (event) => {
            if (window.location.hash.startsWith('#!')) {
                event.preventDefault();
                window.history.back();
            }
        });        
        
        const contactForm = document.getElementById('contactForm');
        window.showContactForm = () => {
            contactForm.showModal();
        };
        window.closeContactForm = () => {
            contactForm.close();
        };
	});
";
$doc->addScriptDeclaration( $script );

$html = '<div class="product">';
$html .= "<h1>$title</h1>";
$html .= '<div class="product__images">';
if (count($ad->images ?? []) > 0) {
    $html .= "<img class=\"product__images__big\" src=\"{$ad->images[0]->href}\">";
    $html .= '<div class="product__images__thumbs">';
    foreach ($ad->images as $key => $image) {
        $html .= "<a href=\"$image->href\"><img class=\"product__images\" src=\"$image->href?width=150\"></a>";
    }
    $html .= '</div>';
} else {
    $html .= "<div class=\"product__images__big product__images__big--empty\"></div>";
}

if ($this->params->get('show_contact', false)) {
// Ansprechpartnermodul
    if ($ad->contact_persons) {
        $html .= '<div class="ad_contact">';
        $html .= '<h3>Ansprechpartner</h3>';
        $html .= '<div class="ad_contact_wrapper">';
        foreach ($ad->contact_persons as $key => $contact) {
            $html .= '<div class="contact-card">';

            if ($contact->image && $contact->image->url) {
                $html .= '<div class="contact-card__image">';
                $html .= "<div><img src='{$contact->image->url}' /></div>";
                $html .= '</div>';
            }

            $html .= '<div class="contact-card__desc">';

            if (trim($contact->description)) {
                $html .= "<h4 class='contact-card__desc_name'>{$contact->description}</h4>";
            }

            $html .= '<table class="contact-card__desc_table">';
            $html .= "<tr><td>E-Mail</td><td><a href='mailto:{$contact->email}'>{$contact->email}</a></td></tr>";

            if ($contact->phone && $contact->phone->call_number) {
                $html .= "<tr><td>Telefon</td><td><span>{$contact->phone->country_code} {$contact->phone->area_code} {$contact->phone->call_number}</span></td></tr>";
            }
            if ($contact->mobile && $contact->mobile->call_number) {
                $html .= "<tr><td>Mobil</td><td><span>{$contact->mobile->country_code} {$contact->mobile->area_code} {$contact->mobile->call_number}</span></td></tr>";
            }
            if ($contact->fax && $contact->fax->call_number) {
                $html .= "<tr><td>Fax</td><td><span>{$contact->fax->country_code} {$contact->fax->area_code} {$contact->fax->call_number}</span></td></tr>";
            }

            $html .= '</table>';

            $html .= '</div>'; // contact_person__desc

            $html .= '</div>'; // ad__contact_person
        }
        $html .= '</div>'; // ad_contact_wrapper Ende
        $html .= '</div>'; // ad_contact Ende
    }
}
$html .= '</div>';
$html .= '<div class="product__description">';

$iconList = [
    'date' => '<svg width="24" height="24" viewBox="0 0 24 24" class="list_item_icon" data-v-d4bb72da="" style="--sx: 1; --sy: 1; --r: 0deg;"><path d="M9,10V12H7V10H9M13,10V12H11V10H13M17,10V12H15V10H17M19,3A2,2 0 0,1 21,5V19A2,2 0 0,1 19,21H5C3.89,21 3,20.1 3,19V5A2,2 0 0,1 5,3H6V1H8V3H16V1H18V3H19M19,19V8H5V19H19M9,14V16H7V14H9M13,14V16H11V14H13M17,14V16H15V14H17Z" data-v-d4bb72da=""></path></svg>',
    'power' => '<svg width="24" height="24" viewBox="0 0 24 24" class="list_item_icon" data-v-d4bb72da="" style="--sx: 1; --sy: 1; --r: 0deg;"><path d="M13,16.18C13.5,16.35 13.9,16.63 14.23,17H15V21H14.21C13.89,21.35 13.5,21.63 13,21.8C11.85,22.22 10.58,21.87 9.78,21H9V17H9.77C10.1,16.63 10.5,16.35 11,16.18V12H13V16.18M12,20A1,1 0 0,0 13,19A1,1 0 0,0 12,18A1,1 0 0,0 11,19A1,1 0 0,0 12,20M17,4H15V5H17V11H7V5H9V4H7V2H17V4M12,9A1,1 0 0,0 13,8A1,1 0 0,0 12,7A1,1 0 0,0 11,8A1,1 0 0,0 12,9Z" data-v-d4bb72da=""></path></svg>',
    'mileage' => '<svg width="24" height="24" viewBox="0 0 24 24" class="list_item_icon" data-v-d4bb72da="" style="--sx: 1; --sy: 1; --r: 0deg;"><path d="M18.1,4.8C18,4.3 17.6,4 17.1,4H13L13.2,7H10.8L11,4H6.8C6.3,4 5.9,4.4 5.8,4.8L3.1,18.8C3,19.4 3.5,20 4.1,20H10L10.3,15H13.7L14,20H19.8C20.4,20 20.9,19.4 20.8,18.8L18.1,4.8M10.4,13L10.6,9H13.2L13.4,13H10.4Z" data-v-d4bb72da=""></path></svg>',
    'fuel_type' => '<svg width="24" height="24" viewBox="0 0 24 24" class="list_item_icon" data-v-d4bb72da="" style="--sx: 1; --sy: 1; --r: 0deg;"><path d="M18,10A1,1 0 0,1 17,9A1,1 0 0,1 18,8A1,1 0 0,1 19,9A1,1 0 0,1 18,10M12,10H6V5H12M19.77,7.23L19.78,7.22L16.06,3.5L15,4.56L17.11,6.67C16.17,7 15.5,7.93 15.5,9A2.5,2.5 0 0,0 18,11.5C18.36,11.5 18.69,11.42 19,11.29V18.5A1,1 0 0,1 18,19.5A1,1 0 0,1 17,18.5V14C17,12.89 16.1,12 15,12H14V5C14,3.89 13.1,3 12,3H6C4.89,3 4,3.89 4,5V21H14V13.5H15.5V18.5A2.5,2.5 0 0,0 18,21A2.5,2.5 0 0,0 20.5,18.5V9C20.5,8.31 20.22,7.68 19.77,7.23Z" data-v-d4bb72da=""></path></svg>',
    'co2_label' => '<svg width="24" height="24" viewBox="0 0 24 24" class="list_item_icon" data-v-d4bb72da="" style="--sx: 1; --sy: 1; --r: 0deg;"><path d="M5,7A2,2 0 0,0 3,9V15A2,2 0 0,0 5,17H8V15H5V9H8V7H5M11,7A2,2 0 0,0 9,9V15A2,2 0 0,0 11,17H13A2,2 0 0,0 15,15V9A2,2 0 0,0 13,7H11M11,9H13V15H11V9M16,10.5V12H19V13.5H17.5A1.5,1.5 0 0,0 16,15V18H20.5V16.5H17.5V15H19A1.5,1.5 0 0,0 20.5,13.5V12A1.5,1.5 0 0,0 19,10.5H16Z" data-v-d4bb72da=""></path></svg>',
    'gear_type' => '<svg width="24" height="24" viewBox="0 0 24 24" class="list_item_icon" data-v-52a8d0d7="" style="--sx: 1; --sy: 1; --r: 0deg;"><path d="M17.25,12C17.25,12.23 17.23,12.46 17.2,12.68L18.68,13.84C18.81,13.95 18.85,14.13 18.76,14.29L17.36,16.71C17.27,16.86 17.09,16.92 16.93,16.86L15.19,16.16C14.83,16.44 14.43,16.67 14,16.85L13.75,18.7C13.72,18.87 13.57,19 13.4,19H10.6C10.43,19 10.28,18.87 10.25,18.7L10,16.85C9.56,16.67 9.17,16.44 8.81,16.16L7.07,16.86C6.91,16.92 6.73,16.86 6.64,16.71L5.24,14.29C5.15,14.13 5.19,13.95 5.32,13.84L6.8,12.68C6.77,12.46 6.75,12.23 6.75,12C6.75,11.77 6.77,11.54 6.8,11.32L5.32,10.16C5.19,10.05 5.15,9.86 5.24,9.71L6.64,7.29C6.73,7.13 6.91,7.07 7.07,7.13L8.81,7.84C9.17,7.56 9.56,7.32 10,7.15L10.25,5.29C10.28,5.13 10.43,5 10.6,5H13.4C13.57,5 13.72,5.13 13.75,5.29L14,7.15C14.43,7.32 14.83,7.56 15.19,7.84L16.93,7.13C17.09,7.07 17.27,7.13 17.36,7.29L18.76,9.71C18.85,9.86 18.81,10.05 18.68,10.16L17.2,11.32C17.23,11.54 17.25,11.77 17.25,12M19,3H5C3.89,3 3,3.89 3,5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19V5C21,3.89 20.1,3 19,3M12,10C10.89,10 10,10.89 10,12A2,2 0 0,0 12,14A2,2 0 0,0 14,12C14,10.89 13.1,10 12,10Z" data-v-52a8d0d7=""></path></svg>',
    'label' => '<svg width="24" height="24" viewBox="0 0 24 24" class="list_item_icon" data-v-52a8d0d7="" style="--sx: 1; --sy: 1; --r: 0deg;"><path d="M2,6H4V18H2V6M5,6H6V18H5V6M7,6H10V18H7V6M11,6H12V18H11V6M14,6H16V18H14V6M17,6H20V18H17V6M21,6H22V18H21V6Z" data-v-52a8d0d7=""></path></svg>',

];

$descriptionList = [
    [
        'icon' => 'power',
        'name' => JText::_( 'COM_PIXELCMS_POWER' ),
        'show' => isset($ad->power) ? "{$ad->power->kW} kW / {$ad->power->PS} PS" : null,
    ],
    [
        'icon' => 'mileage',
        'name' => JText::_( 'COM_PIXELCMS_MILEAGE' ),
        'show' => (isset($ad->mileage) && $ad->mileage->show) ? $ad->mileage->show : '0 Km',
    ],
    [
        'icon' => 'date',
        'name' => JText::_( 'COM_PIXELCMS_FIRST_REGISTRATION' ),
        'show' => (isset($ad->firstRegistration)) ? $ad->firstRegistration : JText::_( 'COM_PIXELCMS_CONDITION_NEW' ),
    ],
    [
        'icon' => 'gear_type',
        'name' => JText::_( 'COM_PIXELCMS_GEAR_TYPE' ),
        'show' => (isset($ad->gearType)) ? JText::_( "COM_PIXELCMS_GEAR_TYPES_{$ad->gearType}" ) : null,
    ],
    [
        'icon' => 'fuel_type',
        'name' => JText::_( 'COM_PIXELCMS_FUEL_TYPE' ),
        'show' => (isset($ad->fuel_type)) ? JText::_( "COM_PIXELCMS_FUEL_TYPES_{$ad->fuel_type}" ) : null,
    ],
    [
        'icon' => 'label',
        'name' => JText::_( 'COM_PIXELCMS_INTERNAL_ID' ),
        'show' => (isset($ad->dealer_internal_id)) ? $ad->dealer_internal_id : null,
    ],
];


if ($this->params->get('print_btn')) {
    $datasheetLink = "https://www.traktorpool.de/search/detail/printpreview/machine_id/$ad->id/nocrawl/1/";

    if ($this->params->get('maschinen_datenblatt_type', 'default') === 'custom'
        || $model !== 'tracktorpool_products'
        || ($model === 'tracktorpool_products' && $ad->status !== 'active')) {
        $query = http_build_query([
            'articleId' => $ad->id,
            'Itemid' => $this->params->get('Itemid'),
            'format' => 'pdf',
        ]);
        $datasheetLink = JRoute::_("index.php?$query");
    }
    $html .= "<a class=\"product__description__download\" href=\"$datasheetLink\" target='_blank' rel=\"noopener noreferrer\"><img src=\"/media/jce/icons/pdf.png\"> Datenblatt</a>";
}

// if (isset($ad->dealer_internal_id)) {
//     $html .= "<small data-label='" . JText::_( 'COM_PIXELCMS_INTERNAL_ID' ) . "' class='product__description__internal_id'>$ad->dealer_internal_id</small>";
// }

$html .= '<div class="product__icon_list" itemprop="description">';

foreach ($descriptionList as $item) {
    if (!$item['show']) continue;

    $html .= '<div class="product__icon">';
    $html .= $iconList[$item['icon']];
    $html .= "<span>{$item['name']}</span>";
    $html .= "<span>{$item['show']}</span>";
    $html .= '</div>';
}

$html .= '</div>';

$price_sytle = PriceStyle::tryFrom($this->params->getInt('price_style', null));

$html .= "<div class=\"product__description__price\">";
if (isset ($ad->price) && isset ($ad->price->values) && $ad->price->values->netto > 0) {
    // $fmt = numfmt_create( 'de_DE', NumberFormatter::CURRENCY );
    $formatted_netto = format_price($ad->price->values->netto, $this->params->getInt('decimals', 2));
    $formatted_brutto = format_price($ad->price->values->brutto, $this->params->getInt('decimals', 2));

    if ($ad->offer) {
        $formatted_old = format_price($ad->price->values->old, $this->params->getInt('decimals', 2));
        $nettoArr[] = "<del>$formatted_old {$ad->price->currency}</del>";
    }
    $nettoArr[] = "$formatted_netto {$ad->price->currency}";

    $html .= "<div>Preis</div>";

    $html .= "<div>";
    if (!$ad->vat->separable) {
        $html .= JText::sprintf('COM_PIXELCMS_VAT_NOT_SEPARABLE_SPRINTF', implode(' ', $nettoArr));
    } else {
        $price_arr = [];
        if (in_array($price_sytle, [PriceStyle::BOTH, PriceStyle::BRUTTO_ONLY])) {
            if ($ad->vat->value) {
                $sprintf_suffix = ($ad->vat->value !== 0.19) ? '_SHOW_VAT' : '';
                $price_arr[] = JText::sprintf( 'COM_PIXELCMS_BRUTTO_SPRINTF' . $sprintf_suffix, "$formatted_brutto {$ad->price->currency}", $ad->vat->value * 100 );
            }
        }
        if (empty($price_arr) || in_array($price_sytle, [PriceStyle::BOTH, PriceStyle::NETTO_ONLY])) {
            $price_arr[] = JText::sprintf('COM_PIXELCMS_NETTO_SPRINTF', implode(' ', $nettoArr));
        }

        // if ($price_sytle === PriceStyle::BOTH && count($price_arr) === 2) {
        //     $price_arr = array_splice($price_arr, -1, 1, "<small>{$price_arr[1]}</small>");
        // }

        $html .= implode(' ', $price_arr);
    }
    $html .= "</div>"; // price
} else {
    $html .= JText::_( 'COM_PIXELCMS_ASK_FOR_PRICE' );
}
$html .= "</div>"; // product__description__price

$html .= $this->displayTeam();

$html .= '<button class="product__request_btn" onclick="showContactForm()">Jetzt anfragen</button>';

$html .= '</div>'; // product__description

$html .= '<div class="product__details">';

$html .= '<div><h4>Technische Daten</h4>';
$html .= '<dl>';

$html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_CCM' ) ." </dt><dd>".number_format($ad->ccm, 0, ',', '.')." cm³</td></div>";
$html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_DOORS' ) ." </dt><dd>{$ad->doors}</dd></div>";
$html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_SEATS' ) ." </dt><dd>{$ad->seats}</dd></div>";
$html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_PREVIOUS_OWNERS' ) ." </dt><dd>" . ($ad->preowners ?? '0') . "</dd></div>";
$html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_COLOR' ) ." </dt><dd>" . JText::_('COM_PIXELCMS_COLORS_' . strtoupper($ad->base_color)) . "</dd></div>";
$html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_INTERIOR_TYPE' ) ." </dt><dd>" . JText::_('COM_PIXELCMS_INTERIOR_TYPE_' . strtoupper($ad->interior_type)) . "</dd></div>";
$html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_INTERIOR_COLOR' ) ." </dt><dd>" . JText::_('COM_PIXELCMS_COLORS_' . strtoupper($ad->interior_color)) . "</dd></div>";

$html .= '</dl>';
$html .= '</div>'; // Technische Daten

$html .= '<div><h4>Umweltdaten</h4>';
if ($ad->eco->co2_label || $ad->eco->co2_label_empty_battery) {
    $html .= '<div class="co2_label" data-co2_normal="'.$ad->eco->co2_label.'" data-co2_discharged="'.$ad->eco->co2_label_empty_battery.'">';
    $html .= '<div><strong>C0<sub>2</sub>-Klasse</strong><div>Auf Grundlage der CO<sub>2</sub>-Emmisionen (kombiniert)</div></div>';

    $co2_label_image = file_get_contents(JPATH_BASE . '/media/com_pixelcms_articles/images/co2_label_without_text.svg');

    if ($ad->eco->co2_label_empty_battery) {
        $html .= $co2_label_image;
    } else {
        $html .= preg_replace('/viewBox="[^"]*"/m', "viewBox=\"0 100 1024 565\"", $co2_label_image, 1);
    }

    $html .= '</div>'; // Technische Daten
}

$html .= '<dl>';
$html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_ENVIRONMENTAL_BADGE' ) ." </dt><dd>" . JText::_('COM_PIXELCMS_DETAILS_ENVIRONMENTAL_BADGE_' . strtoupper($ad->eco->badge ?? 'none')) . "</td></div>";
$html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_EMISSION_CLASS' ) ." </dt><dd>{$ad->eco->emission_class}</dd></div>";
$html .= "<div class='span-col-2 product__details__subheadline'>".JText::_( 'COM_PIXELCMS_DETAILS_FUEL_WLTP_HEADLINE' )."</div>";
if ($ad->eco->range) $html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_ELECTRIC_MOTOR_RANGE' ) ." </dt><dd>{$ad->eco->range} km</dd></div>";
if ($ad->eco->energy_consumption_combined_weighted) $html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_WEIGHTED_COMBINED_ELECTRIC_CONSUMPTION' ) ." </dt><dd>{$ad->eco->energy_consumption_combined_weighted} kWh/100km</dd></div>";
if ($ad->eco->fuel_consumption_combined_weighted) $html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_WEIGHTED_COMBINED_FUEL_CONSUMPTION' ) ." </dt><dd>{$ad->eco->fuel_consumption_combined_weighted} l/100km</dd></div>";
if ($ad->eco->co2_emission) $html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_WEIGHTED_COMBINED_CO2_EMISSIONS' ) ." </dt><dd>{$ad->eco->co2_emission} g/km</dd></div>";
if ($ad->eco->emission_class) $html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_CO2_CLASS_WEIGHTED_COMBINED' ) ." </dt><dd>{$ad->eco->emission_class}</dd></div>";
if ($ad->eco->co2_emission_empty_battery) $html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_WEIGHTED_COMBINED_CO2_EMISSIONS' ) ." </dt><dd>{$ad->eco->co2_emission_empty_battery} g/km</dd></div>";
if ($ad->eco->co2_label_empty_battery) $html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_CO2_CLASS_WEIGHTED_COMBINED' ) ." </dt><dd>{$ad->eco->co2_label_empty_battery}</dd></div>";

$fuelType = FuelType::tryFrom($ad->getData()[VehicleData::FuelType->value]);
if ($fuelType === FuelType::Hybrid || $fuelType === FuelType::Electric) {
    $energy = [];
    if ($ad->eco->energy_consumption_combined) $energy[] = "<strong>{$ad->eco->energy_consumption_combined} kWh/100km (".JText::_( 'COM_PIXELCMS_DETAILS_COMBINED' ).")</strong>";
    if ($ad->eco->energy_consumption_city) $energy[] = "{$ad->eco->energy_consumption_city} kWh/100km (" . JText::_( 'COM_PIXELCMS_DETAILS_CITY' ) . ")";
    if ($ad->eco->energy_consumption_suburban) $energy[] = "{$ad->eco->energy_consumption_suburban} kWh/100km (" . JText::_( 'COM_PIXELCMS_DETAILS_SUBURBAN' ) . ")";
    if ($ad->eco->energy_consumption_countryside) $energy[] = "{$ad->eco->energy_consumption_countryside} kWh/100km (" . JText::_( 'COM_PIXELCMS_DETAILS_COUNTRY_ROAD' ) . ")";
    if ($ad->eco->energy_consumption_highway) $energy[] = "{$ad->eco->energy_consumption_highway} kWh/100km (" . JText::_( 'COM_PIXELCMS_DETAILS_HIGHWAY' ) . ")";

    if (!empty($energy)) {
        $html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_ELECTRICITY_CONSUMPTION' ) ." </dt><dd>";
        $html .= implode('<br>', $energy);
        $html .= '</dd></div>';
    }

    if ($fuelType === FuelType::Hybrid) {
        $empty_battery = [];
        if ($ad->eco->fuel_consumption_empty_battery) $empty_battery[] = "<strong>{$ad->eco->fuel_consumption_empty_battery} l/100km (".JText::_( 'COM_PIXELCMS_DETAILS_COMBINED' ).")</strong>";
        if ($ad->eco->fuel_consumption_empty_battery_city) $empty_battery[] = "{$ad->eco->fuel_consumption_empty_battery_city} l/100km (" . JText::_( 'COM_PIXELCMS_DETAILS_CITY' ) . ")";
        if ($ad->eco->fuel_consumption_empty_battery_suburban) $empty_battery[] = "{$ad->eco->fuel_consumption_empty_battery_suburban} l/100km (" . JText::_( 'COM_PIXELCMS_DETAILS_SUBURBAN' ) . ")";
        if ($ad->eco->fuel_consumption_empty_battery_countryside) $empty_battery[] = "{$ad->eco->fuel_consumption_empty_battery_countryside} l/100km (" . JText::_( 'COM_PIXELCMS_DETAILS_COUNTRY_ROAD' ) . ")";
        if ($ad->eco->fuel_consumption_empty_battery_highway) $empty_battery[] = "{$ad->eco->fuel_consumption_empty_battery_highway} l/100km (" . JText::_( 'COM_PIXELCMS_DETAILS_HIGHWAY' ) . ")";

        if (!empty($empty_battery)) {
            $html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_FUEL_CONSUMPTION_EMPTY_BATTERY' ) ." </dt><dd>";
            $html .= implode('<br>', $empty_battery);
            $html .= '</dd></div>';
        }
    }
}

if ($fuelType !== FuelType::Electric) {
    $fuel_unit = 'l/100Km';

    if ($fuelType === FuelType::CNG || $fuelType === FuelType::LPG) {
        $fuel_unit = 'kg/100km';
    }

    $fuel_consumption = [];
    if ($ad->eco->fuel_consumption_combined) $fuel_consumption[] = "<strong>{$ad->eco->fuel_consumption_combined} $fuel_unit (".JText::_( 'COM_PIXELCMS_DETAILS_COMBINED' ).")</strong>";
    if ($ad->eco->fuel_consumption_city) $fuel_consumption[] = "{$ad->eco->fuel_consumption_city} $fuel_unit (" . JText::_( 'COM_PIXELCMS_DETAILS_CITY' ) . ")";
    if ($ad->eco->fuel_consumption_suburban) $fuel_consumption[] = "{$ad->eco->fuel_consumption_suburban} $fuel_unit (" . JText::_( 'COM_PIXELCMS_DETAILS_SUBURBAN' ) . ")";
    if ($ad->eco->fuel_consumption_countryside) $fuel_consumption[] = "{$ad->eco->fuel_consumption_countryside} $fuel_unit (" . JText::_( 'COM_PIXELCMS_DETAILS_COUNTRY_ROAD' ) . ")";
    if ($ad->eco->fuel_consumption_highway) $fuel_consumption[] = "{$ad->eco->fuel_consumption_highway} $fuel_unit (" . JText::_( 'COM_PIXELCMS_DETAILS_HIGHWAY' ) . ")";

    if (!empty($fuel_consumption)) {
        $html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_FUEL_CONSUMPTION' ) ." </dt><dd>";
        $html .= implode('<br>', $fuel_consumption);
        $html .= '</dd></div>';
    }
}


if ($ad->eco->energy_cost_at_15000km) $html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_ENERGY_COST_AT_15000KM' ) ." </dt><dd>{$ad->eco->energy_cost_at_15000km} €</dd></div>";
if ($ad->eco->fuel_price) $html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_FUEL_PRICE' ) ." </dt><dd>{$ad->eco->fuel_price} €/l</dd></div>";
if ($ad->eco->energy_price) $html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_ENERGY_PRICE' ) ." </dt><dd>{$ad->eco->energy_price} €/kWh</dd></div>";

$co2_cost = [];
if ($ad->eco->co2_cost_average_accumulated) $co2_cost[] = JText::sprintf( 'COM_PIXELCMS_DETAILS_CO2_COST_AVERAGE', $ad->eco->co2_cost_average_accumulated, $ad->eco->co2_cost_average_per_t );
if ($ad->eco->co2_cost_low_accumulated) $co2_cost[] = JText::sprintf( 'COM_PIXELCMS_DETAILS_CO2_COST_LOW', $ad->eco->co2_cost_low_accumulated, $ad->eco->co2_cost_low_per_t );
if ($ad->eco->co2_cost_high_accumulated) $co2_cost[] = JText::sprintf( 'COM_PIXELCMS_DETAILS_CO2_COST_HIGH', $ad->eco->co2_cost_high_accumulated, $ad->eco->co2_cost_high_per_t );

if (!empty($co2_cost)) {
    $html .= '<div><dt>' . JText::_( 'COM_PIXELCMS_DETAILS_CO2_COST_LABEL' ) . '</dt><dd>';
    $html .= implode('<br><br>', $co2_cost);
    $html .= '</dd></dt></div>';
}

//$html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_PREVIOUS_OWNERS' ) ." </dt><dd>" . ($ad->preowners ?? '0') . "</dd></div>";
//$html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_PREVIOUS_OWNERS' ) ." </dt><dd>" . ($ad->preowners ?? '0') . "</dd></div>";
//$html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_COLOR' ) ." </dt><dd>" . JText::_('COM_PIXELCMS_COLORS_' . strtoupper($ad->base_color)) . "</dd></div>";
//$html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_INTERIOR_TYPE' ) ." </dt><dd>" . JText::_('COM_PIXELCMS_INTERIOR_TYPE_' . strtoupper($ad->interior_type)) . "</dd></div>";
//$html .= "<div><dt> ". JText::_( 'COM_PIXELCMS_DETAILS_INTERIOR_COLOR' ) ." </dt><dd>" . JText::_('COM_PIXELCMS_COLORS_' . strtoupper($ad->interior_color)) . "</dd></div>";

$html .= '</dl>';

$html .= '</div>'; // Technische Daten

$html .= '<div><h4>Komfort & Innenausstattung</h4>';
$html .= '<ul>';

$comfort_arr = array_map(function($item) {
    $text = JText::_( 'COM_PIXELCMS_DETAILS_' . strtoupper($item) );
    return "<li>{$text}</li>";
}, $ad->comfortInterior);
sort($comfort_arr);
$html .= implode('', $comfort_arr);

$html .= '</ul>';
$html .= '</div>'; // Technische Daten


$html .= '<div><h4>Audio & Kommunikation</h4>';
$html .= '<ul>';

$media_arr = array_map(function($item) {
    $text = JText::_( 'COM_PIXELCMS_DETAILS_' . strtoupper($item) );
    return "<li>{$text}</li>";
}, $ad->audioCommunication);
sort($media_arr);
$html .= implode('', $media_arr);

$html .= '</ul>';
$html .= '</div>'; // Technische Daten

$html .= '<div class="span-col-2"><h4>Exterieur, Sicherheit & Assistenz</h4>';
$html .= '<ul>';

$safety_arr = array_map(function($item) {
    $text = JText::_( 'COM_PIXELCMS_DETAILS_' . strtoupper($item) );
    return "<li>{$text}</li>";
}, $ad->safetyAssistanceExterior);
sort($safety_arr);
$html .= implode('', $safety_arr);

$html .= '</ul>';
$html .= '</div>'; // Technische Daten

$html .= '</div>'; // product__details

$html .= '</div>'; // product



$html .= '<a href="' . $parentlink . '" id="back_link" class="back_to_overview ad__button">' . JText::_( 'COM_PIXELCMS_BACK_TO_OVERVIEW' ) . '</a>';

$html .= '<div class="fineprint">';
$html .= '<p>' . JText::_( 'COM_PIXELCMS_DETAILS_FUEL_WLTP_DISCLAIMER' ) . '</p>';
$html .= '<p>' . JText::_( 'COM_PIXELCMS_DETAILS_CO2_COST_DISCLAIMER' ) . '</p>';
$html .= '</div>';

$relatedAds =  $this->relatedAds;

if (false) {
    $html .= "<h2>".JText::_( 'COM_PIXELCMS_RELATEDADS' )." {$ad->category->name}</h2>";
    $html .= '<div class="custom ads">';
    foreach (array_slice( $relatedAds, 0, 3) as $key => $ad) {
        $html .= '<div class="ad">';
        if (count($ad->images ?? []) > 0) {
            $html .= "<a class=\"ad__image\" href=\"$ad->link\">";
            $html .= "<div href=\"$ad->link\" class=\"ad__image__wrapper\" style=\"background-image:url({$ad->images[0]->href})\"></div>";
        } else {
            $html .= "<a class=\"ad__image ad__image--empty\" href=\"$ad->link\">";
            $html .= "<div href=\"$ad->link\" class=\"ad__image__wrapper\"></div>";
        }

        $priceStyle = $this->params->get('price_style');
        $html .= '<div class="ad__price">';

        if (isset($ad->price->values) && $ad->price->values->netto > 0) {
            // $fmt = numfmt_create( 'de_DE', NumberFormatter::CURRENCY );
            $formatted_netto = format_price($ad->price->values->netto, $this->params->getInt('decimals', 2));
            $formatted_brutto = format_price($ad->price->values->brutto, $this->params->getInt('decimals', 2));

            $nettoArr = [];
            if ($ad->offer) {
                $formatted_old = format_price($ad->price->values->old, $this->params->getInt('decimals', 2));
                $nettoArr[] = "<del>$formatted_old {$ad->price->currency}</del>";
            }
            $nettoArr[] = "$formatted_netto {$ad->price->currency}";

            if (!$ad->vat->separable) {
                $html .= implode(' ', $nettoArr);
                $html .= '<div>' . JText::_( 'COM_PIXELCMS_VAT_NOT_SEPARABLE' ) . '</div>';
            } else {
                $html .= JText::sprintf('COM_PIXELCMS_NETTO_SPRINTF', implode(' ', $nettoArr));
                if ($ad->vat->value) {
                    $html .= "<div>".JText::sprintf( 'COM_PIXELCMS_BRUTTO_SPRINTF', "$formatted_brutto {$ad->price->currency}" ). "</div>";
                }
            }
        } else {
            $html .= JText::_( 'COM_PIXELCMS_ASK_FOR_PRICE' );
        }
//
//        if (isset($ad->price->values) && $ad->price->values->netto > 0) {
//            if (in_array($priceStyle, [0,1,3,4])) {
//                $html .= "<div> ".JText::_(  in_array($priceStyle, [0,1]) ?  'COM_PIXELCMS_NETTO' : 'COM_PIXELCMS_NETTO_SHORT' )." " . number_format($ad->price->values->netto, 2, ',', '.') . " {$ad->price->currency}"  . "</div>";
//            }
//            if (in_array($priceStyle, [0,2,3,5]) && $ad->vat->value) {
//                $html .= "<div> ".JText::_(  in_array($priceStyle, [0,2]) ?  'COM_PIXELCMS_BRUTTO' : 'COM_PIXELCMS_BRUTTO_SHORT' )." " . number_format($ad->price->values->brutto, 2, ',', '.') . " {$ad->price->currency}"  . "</div>";
//            }
//        } else {
//            $html .= "<div>".JText::_( 'COM_PIXELCMS_ASK_FOR_PRICE' )."</div>";
//        }
        $html .= "</div>";
        $html .= "</a>";

        $html .= "<h3>".implode(' ', [$ad->manufacturer->value, $ad->model])."</h3>";
        if (isset($ad->year) && $ad->year) {
            $html .= "<div>".JText::_('COM_PIXELCMS_BUILD_YEAR').": {$ad->year}</div>";
        }
        if ($ad->power) {
            $html .= "<div>".JText::_('COM_PIXELCMS_POWER').": {$ad->power->kW} kW ({$ad->power->PS} PS)</div>";
        }
        if (isset($ad->workhours) && $ad->workhours->show) {
            $html .= "<div>".JText::_('COM_PIXELCMS_WORKHOURS').": {$ad->workhours->show}</div>";
        }

        $html .= "<a class=\"ad__button\" href=\"$ad->link\">".JText::_('COM_PIXELCMS_READ_MORE')."</a>";

        $html .= '</div>';
    }
    $html .= '</div>';
}
if ($model === 'tracktorpool_products'):
    $html .= "<div class=\"traktorpool-copyright\">Ein Service von <a target=\"_blank\" href=\"https://www.traktorpool.de/{$this->params->get('tracktorpool_alias')}/\"><img src=\"https://www.traktorpool.de/images/frontend/de/logo.svg\" alt=\"Traktorpool\"></a></div>";
endif;

echo $html;
