<?php
$doc = JFactory::getDocument();

JHtml::_('jquery.framework');

$doc->addScript( JUri::base(true) . '/media/com_pixelcms_articles/js/jquery.colorbox-min.js' );
$doc->addStyleSheet( JUri::base(true) . '/media/com_pixelcms_articles/css/colorbox.css' );

$script = "
	jQuery( document ).ready(function() {
		jQuery('.article a.js-img').colorbox({
			rel:'gal',
			scrolling: false,
			maxHeight: '80%',
			maxWidth: '80%',
			fixed: true,
			className: 'droppics',
			title: function(){
			  const title = this.getAttribute('data-title');
			  if (title.match(/\.(jpe?g|png|svg)/)) return null;
			  return title || null;
			},
		});
	});
";
$doc->addScriptDeclaration( $script );

$thumbSize = $this->params->get('pixelcms_images_thumb_size', 500);
$previewSize = $this->params->get('pixelcms_images_preview_size', 1600);

$html[] = "<div class='article article--$this->templateClass'>";
$html[] = "<div class='article_left'>";
if ($this->params->get('show_page_heading')) {
    $html[] = "<h1 class='article__headline'>{$this->article->title}</h1>";
}
$html[] = "<div class='article__content'>";
if ($this->article->images) {
	$html[] = "<div class='article__images images--$this->templateClass'>";
	foreach ($this->article->images as $key => $image) {
	    if ($key >= $this->article->template) break;

        $alt = px_alt_tags($image->title);

		$preview = $this->getThumbnail($image, $previewSize, false);
		if (in_array((int) $this->params->get('cut_images'), [1, 3])) {
			$thumb = $this->getThumbnail($image);
		} else {
            $thumb = $this->getThumbnail($image, $thumbSize, false);
        }
        $html[] = "<a class='js-img' data-title='$image->title' href='{$this->params->get('pixel_cms_url')}/$preview'><img alt='$alt' src='{$this->params->get('pixel_cms_url')}/$thumb'></a>";
    }
	$html[] = "</div>";
}
$html[] = "<div class='article__content__text'>{$this->article->content}</div>";
$html[] = "</div>";
$html[] = $this->displayAttachment($this->article, 'videos');
$html[] = $this->displayAttachment($this->article, 'galleries');
$html[] = $this->displayAttachment($this->article, 'departments');
$html[] = "</div>";

if ($this->hasSidebar()) {
    $html[] = "<div class='article_right'>";
    if ($this->hasAttachment('workers')) {
        $html[] = "<h3>Ansprechpartner</h3>";
        $html[] = $this->displayAttachment($this->article, 'workers');
    }
    if ($this->hasAttachment('pdfs')) {
        $html[] = "<h3>PDFs</h3>";
        $html[] = $this->displayAttachment($this->article, 'pdfs');
    }
    if ($this->hasAttachment('files')) {
        $html[] = "<h3>Dateien</h3>";
        $html[] = $this->displayAttachment($this->article, 'files');
    }
    $html[] = "</div>";
}

$html[] = "</div>";
$html[] = $this->attachPlayerScripts();


echo implode("\n", $html);
