<?php
/**
 * @package     ${NAMESPACE}
 * @subpackage
 *
 * @copyright   A copyright
 * @license     A "Slug" license name e.g. GPL2
 */

if (!function_exists('format_price')) {
    function format_price(float $price, int $decimals = 2): string {
        if ($decimals < 0) {
            $factor = pow(10, min(abs($decimals), ceil(log10(abs($price)) - 1)));
            $price = round($price / $factor) * $factor;
        }

        return number_format($price, max(0, $decimals), ',', '.');
    }
}

if (!function_exists('px_alt_tags')) {
    function px_alt_tags(string $rawText): string {
        $has_extension_regex = '/(.*)\.(jpg|jpeg|png|gif|webp|svg)$/i';
        if ( preg_match( $has_extension_regex, $rawText, $matches ) ) {
            // replace all filename safe varianst of spaces and dashes with spaces and remove the extension
            return preg_replace( '/[-_]/', ' ', $matches[1] );
        }

        return $rawText;
    }
}

if (!function_exists('parse_float')) {
    function parse_float(?string $num): float {
        $dotPos = strrpos($num, '.');
        $commaPos = strrpos($num, ',');
        $sep = (($dotPos > $commaPos) && $dotPos) ? $dotPos :
            ((($commaPos > $dotPos) && $commaPos) ? $commaPos : false);

        if (!$sep) {
            return floatval(preg_replace("/[^0-9]/", "", $num));
        }

        return floatval(
            preg_replace("/[^0-9]/", "", substr($num, 0, $sep)) . '.' .
            preg_replace("/[^0-9]/", "", substr($num, $sep+1, strlen($num)))
        );
    }
}
