<?php

foreach ($this->news as $article) {
    $link = JRoute::_("index.php?option=com_pixelcms_articles&view=pixelcms_news&articleId=$article->uid&Itemid=$this->item_id");
    $classList['show_date'] = $this->params->get('show_date', '');

    $html[] = "<a id='cms_news-$article->uid' class='cms_news {$this->compileClassList($classList)}' href='$link'>";
    if ($article->images) {
        $html[] = "<img role='presentation' alt='' class='cms_news__image' src='{$article->images[0]}'>";
    } else {
        $html[] = "<div class='cms_news__image cms_news__image--empty'></div>";
    }
    $html[] = "<div class=\"cms_news__content\">";
    // $html[] = "<pre style='display: hidden;'>" . print_r($article->manufacturer, true) . '</pre>';
    $html[] = "<img alt='{$article->manufacturer->title} präsentiert: ' " . (($article->manufacturer->color) ? ' style="background-color: '.$article->manufacturer->color.'"' : '') . " class=\"cms_news__manufacturer\" src=\"//cms.pixel-kraft.de{$article->manufacturer->image}\">";

    $date = "<span class='cms_article__date'><span class='sr-only'>Veröffentlicht am: </span>" . DateTime::createFromFormat('Y-m-d H:i:s', $article->datetime)->format('d.m.Y') . "</span>";

    if ($this->params->get('show_date', 0) === 'before') {
        $html[] = $date;
    }
    $html[] = "<h2 class='cms_news__headline'>$article->title</h2>";
    if ($this->params->get('show_date', 0) === 'after') {
        $html[] = $date;
    }

    $html[] = "<p class='cms_news__intro'>{$article->short}</p>";
    $html[] = "</div>";
    $html[] = "</a>";
}
if (!$this->news) {
    $html[] = '&nbsp;'; // Fix empty joomla modules
}

if ($this->params->get('legacy_mode', '0') === '0') {
    $containerClass = $this->getContainerClass();
    $articleCount = count($this->news ?? []);
    array_unshift($html, "<div class=\"$containerClass\" data-count=\"$articleCount\">");
    array_push($html, '</div>');
}
if ($this->params->get('show_page_heading')) {
    array_unshift($html, "<div class=\"page-header\"><h2 itemprop=\"headline\">{$this->params->get('page_title')}</h2></div>");
}

if ($this->pagination && $this->pagination->last_page !== 1) {
    $paginator = $this->pagination;

    $html[] = '<ul class="pagination pg-blue">';

    $html[] = $this->paginationLink(1, $paginator->current_page == 1, '«');

    if ($paginator->current_page > 3) {
        $html[] = '<li class="page-item"><a class="page-link">...</a></li>';
    }

    for ($i = 1; $i <= $paginator->last_page; $i++) {
        if ( ($i > ($paginator->current_page - 3)) && ($i < ($paginator->current_page + 3)) ) {
            $html[] = $this->paginationLink($i, false, null, $paginator->current_page == $i);
        }
    }

    if ($paginator->current_page < ($paginator->last_page - 2)) {
        $html[] = '<li class="page-item"><a class="page-link">...</a></li>';
    }

    $html[] = $this->paginationLink($paginator->last_page, $paginator->current_page == $paginator->last_page, '»');
}

if ($this->params->get('is_module') && $this->params->get('show_archiv', true)) {
    $link = JRoute::_("index.php?Itemid=$this->item_id");
    $html[] = '<div class="clearfix"><a class="archive-link" href="' . $link . '">' . JText::_( 'COM_PIXELCMS_ARCHIVE' ) . '</a></div>';
}

echo implode("\n", $html);
