<?php
$doc = JFactory::getDocument();

if ($this->params->get('show_page_heading')) {
	$html[] = "<div class=\"page-header\">";
	$html[] = "<h1 itemprop=\"headline\">{$this->params->get('page_title')}</h1>";
	$html[] = "</div>";
}

$doc->addScript('https://cdnjs.cloudflare.com/ajax/libs/cssuseragent/2.1.31/cssua.min.js');

if (!function_exists('isSSL')) {
    function isSSL() {
        return (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off')
            || $_SERVER['SERVER_PORT'] == 443
            || !empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https'
            || !empty($_SERVER['HTTP_X_FORWARDED_SSL']) && $_SERVER['HTTP_X_FORWARDED_SSL'] == 'on';
    }
}
if (!function_exists('isHTTPS')) {
    function isHTTPS($link) {
        return strpos($link, 'https') === 0;
    }
}


$html[] = "<div class='manufacturers'>";
foreach ($this->manufacturers as $manufacturer) {
    $html[] = "<article class=\"manufacturer\" id='m-$manufacturer->id' data-manufacturer='$manufacturer->title'>";
    // $html[] = "<div class=\"manufacturer__header\" id=\"uid-$manufacturer->id\">";
    // $html[] = "<h3>$manufacturer->title</h3>";
    // $html[] = "</div>";
    $headingClass = '';
    if (($manufacturer->color)) {
        $html[] = "<h2 style='background: $manufacturer->color' class=\"manufacturer__image\">";
    } else {
        $html[] = "<h2 class=\"manufacturer__image\">";
    }
    if ($manufacturer->image) {
        $headingClass = 'sr-only';
        $html[] = "<img src=\"{$this->params->get('pixel_cms_url')}$manufacturer->image\" width=\"160\" height=\"55\" alt=\"\">";
    }
    $html[] = "<span class='$headingClass'>{$manufacturer->title}</span>";
    $html[] = "</h2>";
    $html[] = "<ul class='manufacturer__links' id=\"ulid-$manufacturer->id\">";
    foreach ($manufacturer->links as $link) {
        $html[] = "<li><a id='ml-$link->id' class='manufacturer__links__link " . (($link->iframeable && (isSSL() && isHTTPS($link->url) || !isSSL())) ? 'manufacturer__links__link--iframe' : '') . "' href=\"$link->url\" target=\"_blank\">$link->title</a></li>";
    }
    $html[] = "</ul>";
    if (isset($manufacturer->pivot)) {
        if (isset($manufacturer->pivot->notice) && !empty($manufacturer->pivot->notice)) {
            $notice = nl2br($manufacturer->pivot->notice);
            $html[] = "<div class=\"manufacturer__notice\">$notice</div>";
        }
    }
    $html[] = "</article>";
}

$html[] = "</div>";

$script = 'var wrapper = document.createElement(\'div\');
  wrapper.className = \'manufacturer_box manufacturer_box--hidden\';

  var header = document.createElement(\'div\');
  header.className = \'manufacturer_box__header\';

  var body = document.createElement(\'div\');
  body.className = \'manufacturer_box__body\';

  var iframe = document.createElement(\'iframe\');
  iframe.className = \'manufacturer_box__body__iframe\';

  var close = document.createElement(\'i\');
  close.className = \'fa fa-times-circle manufacturer_box__header__close\';

  close.addEventListener(\'click\', function(ev) {
    px_iframe.iframe.src = \'\';
    px_iframe.wrapper.classList.add(\'manufacturer_box--hidden\');
    document.body.classList.remove("overflow-hidden");
  });

  var title = document.createElement(\'span\');
  title.className = \'manufacturer_box__header__title\';

  document.body.addEventListener(\'click\', function(ev) {
    if (!wrapper.contains(ev.target)) {
      px_iframe.wrapper.classList.add(\'manufacturer_box--hidden\');
      document.body.classList.remove("overflow-hidden");
      px_iframe.iframe.src = \'\';
    }
  });

  wrapper.appendChild(header);
  wrapper.appendChild(body);
  body.appendChild(iframe);
  header.appendChild(title);
  header.appendChild(close);

  window.px_iframe = {
    header:header,
    wrapper:wrapper,
    body:body,
    iframe:iframe,
    title:title,
  };

  document.body.appendChild(wrapper);
  [].slice.call(document.querySelectorAll(".manufacturer__links__link--iframe")).forEach(function (el) {
    el.manufacturer = el.parentElement.parentElement.parentElement.dataset.manufacturer;
    el.addEventListener("click", function(ev){
        ev.preventDefault();
        ev.stopPropagation();
        px_iframe.title.innerText = ev.target.manufacturer + \' - \' + ev.target.title;
	    px_iframe.iframe.src = ev.target.href;
	    px_iframe.wrapper.classList.remove(\'manufacturer_box--hidden\');
	    document.body.classList.add("overflow-hidden");
    });
  });
  ';

$script = preg_replace('/[\s]{2,}/', '', $script);
$script = preg_replace('/[\s]*([=+])[\s]*/', '$1', $script);
$html[] = "<script>$script</script>";

echo implode("\n", $html);
