<?php
/**
 * @package    pixelcms_articles
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

use Joomla\CMS\MVC\View\HtmlView;

defined('_JEXEC') or die;

/**
 * Pixelcms_articles view.
 *
 * @package  pixelcms_articles
 * @since    1.0
 */
class Pixelcms_articlesViewPixelcms_teams extends HtmlView
{
    protected $team;
    protected $params;

    protected $is_module = false;

    static $attachments = [
        'galleries' => 'gallery',
        'workers' => 'worker',
        'pdfs' => 'pdf',
        'files' => 'file',
        'videos' => 'video',
        'images' => 'image',
        'locations' => 'location',
        'departments' => 'department',
    ];

	public function displayWorker($worker, $wrapContent = false)
	{
		//$html[] =  "<pre>". print_r($worker, true) ."</pre>";
		if ($worker->image) {
			$thumb = preg_replace('/(^(?!http)(?:(?!thumb).)*)\.(jpe?g|png|gif)/', '$1.500-cropped.$2', $worker->image->url);
			$html[] = "<div class='worker__image' style='background-image: url({$this->params->get('pixel_cms_url')}{$thumb})'></div>";
		} else {
			$gender = ($worker->title === 2) ? 'female' : 'male';
			$html[] = "<div class='worker__image worker__image--empty worker__image--empty--$gender'></div>";
		}
		if ($wrapContent) {
            $html[] = "<div class='worker__content'>";
        }
		$html[] = "<h4 class='worker__title'>$worker->first_name $worker->last_name</h4>";
		if (isset($worker->role)) {
			$html[] = "<span class=\"worker__role\">$worker->role</span>";
		}
		$html[] = "<ul class=\"worker__contact\">";
		if ($worker->email) {
			$html[] = "<li><a class='emails--encrypted' href=\"mailto:$worker->email\"><i class=\"pixelcms-icons\">email</i><span>$worker->email</span></a></li>";
		}
		if ($worker->tel) {
			$telNumber = $this->getCallablePhone($worker->tel);
			$displayNumber = $this->getDisplayablePhone(($worker->tel));
			$html[] = "<li><a href=\"tel:$telNumber\"><i class=\"pixelcms-icons\">phone</i><span>$displayNumber</span></a></li>";
		}
		if ($worker->mobile) {
			$telNumber = $this->getCallablePhone($worker->mobile);
			$displayNumber = $this->getDisplayablePhone(($worker->mobile));
			$html[] = "<li><a href=\"tel:$telNumber\"><i class=\"pixelcms-icons\">phone_android</i><span>$displayNumber</span></a></li>";
		}
		if ($worker->fax) {
			$telNumber = $this->getCallablePhone($worker->fax);
			$displayNumber = $this->getDisplayablePhone(($worker->fax));
			$html[] = "<li><a href=\"fax:$telNumber\"><i class=\"pixelcms-icons\">print</i><span>$displayNumber</span></a></li>";
		}
        $html[] =  "</ul>";

		if ($worker->bio) {
            $replacedLinebreaks = str_replace(array("\r\n", "\n", "\r"), '<br />', $worker->bio);
            $html[] = "<div class='worker__bio'>$replacedLinebreaks</div>";
        }

        if ($wrapContent) {
            $html[] = "</div>";
        }
		return implode("\n", $html);
	}

	private function getCallablePhone($phone)
	{
		return preg_replace([
			'/[\s\/\-]/',
			'/(\+\s?\d{2})(?:\s?(?:\(0\)|0)\s?)?/',
		], [
			'',
			'$1',
		], $phone);
	}

	private function getDisplayablePhone($phone)
	{
		return preg_replace([
			//'/(\d)\s(\d)/',
			'/ - /',
			// '/\+\s?\d{2}\s?(?:\s?(?:\(0\)|0)\s?)?/',
		], [
			//'$1$2',
			' ',
			// '0',
		], $phone);
	}

    public function getContainerClass(): string
    {
        $viewName = $this->getName();

        $classList[] = "$viewName-wrapper";
        if ($this->params->get('is_module')) {
            $classList[] = 'mod_cms-wrapper';
            $classList[] = "$viewName-mod-wrapper";
        }

        return implode(' ', $classList);
    }

	function display($tpl = null)
	{
		// Assign data to the view
        $this->team = $this->get('Team');
		$this->params = $this->get('state')->get('params');

        if (gettype($this->team) === 'array') {
	        $tpl = 'listing';
        }

        $document = JFactory::getDocument();
        $document->addStyleSheet(JURI::base(true) . '/media/com_pixelcms_articles/css/fonts.css', [
            'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/css/fonts.css'),
        ]);
        $document->addStyleSheet(JURI::base(true) . '/media/com_pixelcms_articles/css/style.css', [
            'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/css/style.css'),
        ]);
        $document->addScript(JURI::base(true) . '/media/com_pixelcms_articles/js/script.js', [
            'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/js/script.js'),
        ]);

		// Display the view
		parent::display($tpl);
	}
}
