<?php
$ad = $this->ads;
$priceStyle = $this->params->get('price_style', 0);

$html[] = '<div class="ad ad--promo">';
$html[] = "<a class=\"ad__image\" href=\"$ad->link\">";

if (count($ad->images ?? []) > 0) {
    $html[] = "<div class=\"ad__image__wrapper\" style=\"background-image: url('{$ad->images[0]->href}')\"></div>";
}

$html[] = "<div class=\"ad__price\"><!-- open ad__price -->";
if (in_array($priceStyle, [0, 1, 3, 4])) {
    $formatted_netto = number_format($ad->price->values->netto, 2, ',', '.');
    $html[] = "<div><!-- open netto -->"; // netto
    $html[] = JText::_('COM_PIXELCMS_NETTO'. in_array($priceStyle, [0,1]) ? '' : '_SHORT');
    if ($ad->offer) {
        $formatted_old = number_format($ad->price->values->old, 2, ',', '.');
        $html[] = "<del>$formatted_old {$ad->price->currency}</del><br />";
    }
    $html[] = "$formatted_netto {$ad->price->currency}";
    $html[] = "</div><!-- close netto -->"; // netto
}
if (in_array($priceStyle, [0, 2, 3, 5]) && $ad->vat->value) {
    $formatted_brutto = number_format($ad->price->values->brutto, 2, ',', '.');
    $html[] = "<div><!-- open brutto -->";
    $html[] = JText::_('COM_PIXELCMS_BRUTTO'. in_array($priceStyle, [0,1]) ? '' : '_SHORT');
    $html[] = "$formatted_brutto {$ad->price->currency}";
    $html[] = "</div><!-- close brutto -->";
}
$html[] = '</div><!-- closing ad__price -->'; // ad__price
$html[] = '</a><!-- closing ad__image -->'; // ad__image

$html[] = '<div class="product__description">';
$html[] = "<h3>" . implode(' ', [$ad->manufacturer->value, $ad->model]) . "</h3>";
if (isset($ad->year)) $html[] = '<div>' . JText::_( 'COM_PIXELCMS_BUILD_YEAR' ).": {$ad->year}</div>";
if (isset($ad->power)) $html[] = '<div>' . JText::_( 'COM_PIXELCMS_POWER' ).": {$ad->power->PS}</div>";
if ($ad->workhours && $ad->workhours->show) $html[] = '<div>' . JText::_( 'COM_PIXELCMS_WORKHOURS' ).": {$ad->workhours->show}</div>";
$html[] = '</div><!-- closing product__description -->'; // product__description
$html[] = '</div><!-- closing ad -->'; // ad


echo implode('', $html);
