<?php
$doc = JFactory::getDocument();

JHtml::_('jquery.framework');

$doc->addScript( JUri::base(true) . 'media/com_pixelcms_articles/js/jquery.colorbox-min.js' );
$doc->addStyleSheet( JUri::base(true) . 'media/com_pixelcms_articles/css/colorbox.css' );

$script = "
	jQuery( document ).ready(function() {
		jQuery('.article a.js-img').colorbox({
			rel:'gal',
			scrolling: false,
			maxHeight: '80%',
			maxWidth: '80%',
			fixed: true,
			className: 'droppics'
		});
	});
";
$doc->addScriptDeclaration( $script );

$html[] = "<div class='article'>";
$html[] = "<div class='article_left'>";
$html[] = "<h1 class='article__headline'>{$this->news->title}</h1>";
$html[] = "<div class='article__content'>";

if (count($this->news->images) > 1 || $this->news->images && $this->params->get('disable_title_image')) {
    $html[] = "<div class='article__images'>";
    foreach ($this->news->images as $key => $image) {
        if ($key === 0 && !$this->params->get('disable_title_image')) continue;

        if (in_array((int) $this->params->get('cut_images'), [1, 3]) ) {
            $html[] = "<a href='$image' class='js-img img' style='background-image: url($image)'></a>";
        } else {
            $html[] = "<a class='js-img' href='$image'><img src='$image' width='400'></a>";
        }
    }
    $html[] = "</div>";
}

$html[] = "<p>{$this->news->bodytext}</p>";
$html[] = "</div>";
$html[] = "</div>";
$html[] = "</div>";

echo implode("\n", $html);
