<?php

if (!isset($testimonial)) {
    $testimonial = $this->testimonials;
}

$html[] = '<blockquote class="testimonial">';
$html[] = "<div class='testimonial__content'>$testimonial->content</div>";
$html[] = '<cite>';
$html[] = '<div class="testimonial__source'.(($testimonial->author_image) ? ' testimonial__source--has-image' : '').'">';
if ($testimonial->author_image) {
    $thumb = $this->getThumbnail($testimonial->author_image->url, $this->params->getInt('pixelcms_images_testimonial_size', 128), true);
    $html[] = "<img alt='$testimonial->author' class='testimonial__source__image' src='https://cms.pixel-kraft.de{$thumb}'>";
}
$html[] = '<div class="testimonial__source_wrapper">';
if ($testimonial->author) {
    $html[] = "<div class='testimonial__source__author'>$testimonial->author</div>";
}
if ($testimonial->company) {
    $html[] = "<div class='testimonial__source__company'>$testimonial->company</div>";
}
$html[] = '</div>'; // testimonial__source_wrapper
$html[] = '</div>'; // testimonial__source
$html[] = '</cite>';
$html[] = '</blockquote>';

echo implode("\n", $html);
