<?php
/**
 * @package    pixelcms_articles
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

use Joomla\CMS\MVC\View\HtmlView;

defined('_JEXEC') or die;

/**
 * Pixelcms_articles view.
 *
 * @package  pixelcms_articles
 * @since    1.0
 */
class pixelcms_articlesViewtracktorpool_products extends HtmlView
{
    protected $ads;
    protected $locale;
    protected $relatedAds;
    protected $uid;
    protected $params;
    protected $is_module = false;

	function display($tpl = null)
	{
		// Assign data to the view
        $this->ads = $this->get('Data');
        $this->locale = $this->get('Locale');
		$this->params = $this->get('state')->get('params');
        $this->uid = bin2hex(random_bytes(10));

        $lang = JFactory::getLanguage();
        $langCode = $lang->getTag();
        $langCodeShort = substr($langCode, 0, 2);

		$document = JFactory::getDocument();
		if (gettype($this->ads) === 'array') {
	        $tpl = 'listing';

            if ($this->getLayout() === 'default' && $this->params->get('next_ui', false)) {
                $this->setLayout('next');

                $appURI = JURI::base(true) . '/media/com_pixelcms_articles/dist/pixelcms.es.js?' . md5_file(JPATH_BASE . '/media/com_pixelcms_articles/dist/pixelcms.es.js');

                $script = "
                    import MachineMarketplace from '{$appURI}';

                    MachineMarketplace('#app-{$this->uid}', {
                      pageSize: {$this->params->get('page_size', 16)},
                      settings: {
                        decimals: {$this->params->getInt('decimals', 2)}
                      },
                      lang: \"{$langCodeShort}\",
                      machines: ". json_encode($this->ads) .",
                    });
                ";

                $document->addStyleSheet(JURI::base(true) . '/media/com_pixelcms_articles/dist/style.css', [
                    'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/dist/style.css'),
                ]);

                $document->addScriptDeclaration( $script, 'module' );
            } else {
                $document->addScript(JURI::base(true) . '/media/com_pixelcms_articles/js/vue.min.js', [
                    'version' => '2.5.16',
                ]);
            }
        } else {
            $this->relatedAds = $this->get('RelatedAds');

            $ad = $this->ads;
            $title = implode(' ', [$ad->manufacturer->value, $ad->model]);
            $input = JFactory::getApplication()->input;
            $input->set('px-title', $title);
            $input->set('px-art-nr', $ad->dealer_internal_id ?? $ad->id);
        }

        $document->addScript(JURI::base(true) . '/media/com_pixelcms_articles/js/cssua.min.js', [
            'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/js/cssua.min.js'),
        ]);
		$document->addStyleSheet(JURI::base(true) . '/media/com_pixelcms_articles/css/fonts.css', [
            'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/css/fonts.css'),
        ]);
        $document->addStyleSheet(JURI::base(true) . '/media/com_pixelcms_articles/css/machine_details.css', [
            'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/css/machine_details.css'),
        ]);
        $document->addStyleSheet(JURI::base(true) . '/media/com_pixelcms_articles/css/style.css', [
        	'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/css/style.css'),
        ]);
        $document->addScript(JURI::base(true) . '/media/com_pixelcms_articles/js/script.js', [
	        'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/js/script.js'),
        ]);

		// Display the view
		parent::display($tpl);
	}

    protected function _setPath($type, $path)
    {
        $component = 'com_pixelcms_articles';
        $app = JFactory::getApplication();

        // Clear out the prior search dirs
        $this->_path[$type] = array();

        // Actually add the user-specified directories
        $this->_addPath($type, $path);

        // Always add the fallback directories as last resort
        switch (strtolower($type))
        {
            case 'template':
                // Set the alternative template search dir
                if (isset($app))
                {
                    $component = preg_replace('/[^A-Z0-9_\.-]/i', '', $component);
                    $fallback = JPATH_THEMES . '/' . $app->getTemplate() . '/html/' . $component . '/' . $this->getName();
                    $this->_addPath('template', $fallback);
                }
                break;
        }
    }
}
