<?php
$doc = JFactory::getDocument();

JHtml::_('jquery.framework');

$doc->addScript( JUri::base(true) . 'media/com_pixelcms_articles/js/jquery.colorbox-min.js' );
$doc->addStyleSheet( JUri::base(true) . 'media/com_pixelcms_articles/css/colorbox.css' );

$script = "
	jQuery( document ).ready(function() {
		jQuery('.article a.js-img').colorbox({
			rel:'gal',
			scrolling: false,
			maxHeight: '80%',
			maxWidth: '80%',
			fixed: true,
			className: 'droppics'
		});
	});
";
$doc->addScriptDeclaration( $script );

function getTab($article, $that) {
    $thumbSize = $that->params->get('pixelcms_images_thumb_size', 500);
    $previewSize = $that->params->get('pixelcms_images_preview_size', 1600);

    $html[] = "<div class='article'>";
	$html[] = "<div class='article_left'>";
	$html[] = "<h1 class='article__headline'>{$article->title}</h1>";
	$html[] = "<div class='article__content'>";
	if ($article->images) {
		$html[] = "<div class='article__images'>";
		foreach ($article->images as $key => $image) {
			$preview = $that->getThumbnail($image->url, $previewSize, false);
			if ($that->params->get('cut_images')) {
				$thumb = $that->getThumbnail($image->url);
				$html[] = "<a href='{$that->cms_url}{$preview}' class='js-img img' style='background-image: url({$that->cms_url}{$thumb})'></a>";
			} else {
				$thumb = $that->getThumbnail($image->url, $thumbSize, false);
				$html[] = "<a class='js-img' href='{$that->cms_url}{$preview}'><img src='{$that->cms_url}{$thumb}'></a>";
			}
		}
		$html[] = "</div>";
	}
	$html[] = "<p>{$article->content}</p>";
	$html[] = "</div>";
	$html[] = $that->displayAttachment($article, 'videos');
	$html[] = $that->displayAttachment($article, 'galleries');
	$html[] = $that->displayAttachment($article, 'departments');
	$html[] = "</div>";

	$html[] = "</div>";
	$html[] = $that->attachPlayerScripts();


	return implode("\n", $html);
}
