<?php

foreach ($this->news as $article) {
    $link = JRoute::_("index.php?option=com_pixelcms_articles&view=pixelcms_news&articleId=$article->uid&Itemid=$this->item_id");
    $classList['show_date'] = $this->params->get('show_date', '');

    $html[] = "<div id='cms_news-$article->uid' class='cms_news {$this->compileClassList($classList)}'>";
    if ($article->images) {
        if (in_array((int) $this->params->get('cut_images'), [1, 2])) {
            $html[] = "<div class='cms_news__image' style='background-image: url({$article->images[0]})'></div>";
        } else {
            $html[] = "<div class='cms_news__image'><img src='{$article->images[0]}'></div>";
        }
    } else {
        $html[] = "<div class='cms_news__image'></div>";
    }
    $html[] = "<div class=\"cms_news__content\">";
    $html[] = "<img" . (($article->manufacturer->color) ? ' style="background-color: '.$article->manufacturer->color.'"' : '') . " class=\"cms_news__manufacturer\" src=\"//cms.pixel-kraft.de{$article->manufacturer->image}\">";

    $date = "<span class='cms_article__date'>" . DateTime::createFromFormat('Y-m-d H:i:s', $article->datetime)->format('d.m.Y') . "</span>";

    if ($this->params->get('show_date', 0) === 'before') {
        $html[] = $date;
    }
    $html[] = "<a href='$link'><h2 class='cms_news__headline'>$article->title</h2></a>";
    if ($this->params->get('show_date', 0) === 'after') {
        $html[] = $date;
    }

    $html[] = "<p class='cms_news__intro'>{$article->short}</p>";
    $html[] = "<a class=\"cms_news__readmore\" href=\"$link\">Weiterlesen</a>";
    $html[] = "</div>";
    $html[] = "</div>";
}
if (!$this->news) {
    $html[] = '&nbsp;'; // Fix empty joomla modules
}

if ($this->params->get('legacy_mode', '0') === '0') {
    $containerClass = $this->getContainerClass();
    $articleCount = count($this->news);
    array_unshift($html, "<div class=\"$containerClass\" data-count=\"$articleCount\">");
    array_push($html, '</div>');
}
if ($this->params->get('show_page_heading')) {
    array_unshift($html, "<div class=\"page-header\"><h2 itemprop=\"headline\">{$this->params->get('page_title')}</h2></div>");
}

if ($this->pagination && $this->pagination->last_page !== 1) {
    $paginator = $this->pagination;

    $html[] = '<ul class="pagination pg-blue">';

    $html[] = $this->paginationLink(1, $paginator->current_page == 1, '«');

    if ($paginator->current_page > 3) {
        $html[] = '<li class="page-item"><a class="page-link">...</a></li>';
    }

    for ($i = 1; $i <= $paginator->last_page; $i++) {
        if ( ($i > ($paginator->current_page - 3)) && ($i < ($paginator->current_page + 3)) ) {
            $html[] = $this->paginationLink($i, false, null, $paginator->current_page == $i);
        }
    }

    if ($paginator->current_page < ($paginator->last_page - 2)) {
        $html[] = '<li class="page-item"><a class="page-link">...</a></li>';
    }

    $html[] = $this->paginationLink($paginator->last_page, $paginator->current_page == $paginator->last_page, '»');
}

if ($this->params->get('is_module') && $this->params->get('show_archiv', true)) {
    $link = JRoute::_("index.php?Itemid=$this->item_id");
    $html[] = '<div class="clearfix"><a class="archive-link" href="' . $link . '">' . JText::_( 'COM_PIXELCMS_ARCHIVE' ) . '</a></div>';
}

echo implode("\n", $html);
