<?php
/**
 * @package    pixelcms_articles
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

use Joomla\CMS\MVC\View\HtmlView;

defined('_JEXEC') or die;

class PxPDF extends TCPDF {
    public function ImageSVG($file, $x = '', $y = '', $w = 0, $h = 0, $link = '', $align = '', $palign = '', $border = 0, $fitonpage = false)
    {
        if (is_file($file) && is_readable($file))
        {
            $file = '@' . file_get_contents($file);

            // Logo needs dimensions
            if (!preg_match('/<svg [^>]* width="\d+px" [^>]*>/', $file)) {
                // Add width and height from viewBox
                $pattern = '/<svg [^>]* viewBox="\d+ \d+ (\d+) (\d+)" [^>]*>/';
                $subst = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="\1px" height="\2px">';

                $file = preg_replace($pattern, $subst, $file, 1);
            }
        }

        return parent::ImageSVG($file, $x, $y, $w, $h, $link, $align, $palign, $border, $fitonpage);
    }

    public function Image($file, $x = '', $y = '', $w = 0, $h = 0, $type = '', $link = '', $align = '', $resize = false, $dpi = 300, $palign = '', $ismask = false, $imgmask = false, $border = 0, $fitbox = false, $hidden = false, $fitonpage = false, $alt = false, $altimgs = [])
    {
        return parent::Image(
            $file,
            $x,
            $y,
            $w,
            $h,
            $type,
            $link,
            $align,
            true, // always resize images
            100, // Carefully selected size for images
            $palign,
            $ismask,
            $imgmask,
            $border,
            $fitbox,
            $hidden,
            $fitonpage,
            $alt,
            $altimgs
        );
    }

    public function SetData($key, $value)
    {
        $this->{$key} = $value;
    }
}

/**
 * Pixelcms_articles view.
 *
 * @package  pixelcms_articles
 * @since    1.0
 */
class pixelcms_articlesViewtracktorpool_products extends HtmlView
{
    protected $ads;
    protected $locale;
    protected $relatedAds;
    protected $params;
    protected $is_module = false;

    public function __construct($config = [])
    {
        parent::__construct($config);

        $document = JFactory::getDocument();

        $document->setMimeEncoding('application/pdf');
        $document->setType('pdf');
    }

    function display($tpl = null)
	{
		// Assign data to the view
        $this->ads = $this->get('Data');
        $this->locale = $this->get('Locale');
		$this->params = $this->get('state')->get('params');


		if (gettype($this->ads) === 'array') {
	        throw new Exception('PDF view not available for listings');
        }

		try {
            $result = $this->loadTemplate('pdf');
        } catch (\Exception $exception) {
            return $exception;
        }

        $this->renderPdf($result);
	}

    protected function renderPdf($data)
    {
        $pdf = new PxPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', true);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 9);

        $pdf->setListIndentWidth(3);
        $pdf->setJPEGQuality(80);

        $tagvs = [
            'p' => [0 => ['h' => 1, 'n' => 0], 1 => ['h' => 1, 'n' => 0]],
            // 'div' => [0 => ['h' => 0, 'n' => 0], 1 => ['h' => 2, 'n' => 2]],
            'h2' => [0 => ['h' => 0, 'n' => 0], 1 => ['h' => 2, 'n' => 2]],
            'h4' => [0 => ['h' => 0, 'n' => 0], 1 => ['h' => 0.5, 'n' => 2]],
            'small' => [0 => ['h' => 'cm', 'n' => 1], 1 => ['h' => 'cm', 'n' => 1]],
            'ol' => [0 => ['h' => 0, 'n' => 0], 1 => ['h' => 0, 'n' => 0]],
            'ul' => [0 => ['h' => 1, 'n' => -10], 1 => ['h' => 1, 'n' => -10]],
            //'li' => [0 => ['h' => 1, 'n' => -10], 1 => ['h' => 1, 'n' => 0]],
        ];
        $pdf->setHtmlVSpace($tagvs);

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);

        $pdf->setData('header_logo', $this->params->get('maschinen_datenblatt_logo', false));
        $pdf->setData('header_logo_width', $this->params->get('maschinen_datenblatt_logo_size', 30));
        $pdf->setData('header_title', "{$this->ads->manufacturer->value} {$this->ads->model}");
        $pdf->setData('header_string', "Interne Nr.: {$this->ads->dealer_internal_id}");

        $pdf->AddPage();

        $pdf->writeHTML($data, true, false, true, false, '');

        $pdf->Output("inserat-nr_{$this->ads->dealer_internal_id}.pdf", 'I');
    }


    protected function _setPath($type, $path)
    {
        $component = 'com_pixelcms_articles';
        $app = JFactory::getApplication();

        // Clear out the prior search dirs
        $this->_path[$type] = array();

        // Actually add the user-specified directories
        $this->_addPath($type, $path);

        // Always add the fallback directories as last resort
        switch (strtolower($type))
        {
            case 'template':
                // Set the alternative template search dir
                if (isset($app))
                {
                    $component = preg_replace('/[^A-Z0-9_\.-]/i', '', $component);
                    $fallback = JPATH_THEMES . '/' . $app->getTemplate() . '/html/' . $component . '/' . $this->getName();
                    $this->_addPath('template', $fallback);
                }
                break;
        }
    }
}
