<?php
/**
 * @package    pixelcms_articles
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

use Joomla\CMS\MVC\View\HtmlView;

defined('_JEXEC') or die;

/**
 * Pixelcms_articles view.
 *
 * @package  pixelcms_articles
 * @since    1.0
 */
class Pixelcms_articlesViewPixelcms_testimonials extends HtmlView
{
    protected $testimonials;
    protected $params;

    public function getThumbnail(string $url, int $size = 500, bool $cropped = true): string
    {
        return preg_replace('/(^(?!http)(?:(?!thumb).)*)\.(jpe?g|png|gif)/', ($cropped) ? "$1.$size-cropped.$2" : "$1.$size.$2", $url);
    }

    function display($tpl = null)
	{
		// Assign data to the view
        $this->testimonials = $this->get('Testimonials');
		$this->params = $this->get('state')->get('params');

        if (gettype($this->testimonials) === 'array') {
	        $tpl = 'listing';
        }

        $document = JFactory::getDocument();
        $document->addStyleSheet(JURI::base(true) . '/media/com_pixelcms_articles/css/style.css', [
            'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/css/style.css'),
        ]);

		// Display the view
		parent::display($tpl);
	}
}
