<?php
/**
 * @package     ${NAMESPACE}
 * @subpackage
 *
 * @copyright   A copyright
 * @license     A "Slug" license name e.g. GPL2
 */

if (!function_exists('format_price')) {
    function format_price(float $price, int $decimals = 2): string {
        if ($decimals < 0) {
            $factor = pow(10, min(abs($decimals), ceil(log10(abs($price)) - 1)));
            $price = round($price / $factor) * $factor;
        }

        return number_format($price, max(0, $decimals), ',', '.');
    }
}
