<?php

$ad = $this->ads;

$title = "{$ad->manufacturer->value} {$ad->model}";
$images = array_map(function ($img) {
    return $img->href;
}, $ad->images);


$contactBlock = [];
if (true) {
// Ansprechpartnermodul
    if ($ad->contact_persons) {
        $contactBlock[] = '<table cellpadding="2" cellspacing="0"><tr>';
        foreach ($ad->contact_persons as $key => $contact) {
            $contactBlock[] = '<td style="font-size: 6px">';

            $contactBlock[] = '<table style="border: solid 1px #ccc" cellpadding="2" cellspacing="0">';

            $contactBlock[] = "<tr><td width=\"30\">Name:</td><td width=\"110\">$contact->description</td></tr>";
            $contactBlock[] = "<tr><td>E-Mail:</td><td>{$contact->email}</td></tr>";

            if ($contact->phone) {
                $contactBlock[] = "<tr><td>Telefon:</td><td><span>{$contact->phone->country_code} {$contact->phone->area_code} {$contact->phone->call_number}</span></td></tr>";
            }
            if ($contact->mobile) {
                $contactBlock[] = "<tr><td>Mobil:</td><td><span>{$contact->mobile->country_code} {$contact->mobile->area_code} {$contact->mobile->call_number}</span></td></tr>";
            }
            if ($contact->fax) {
                $contactBlock[] = "<tr><td>Fax:</td><td><span>{$contact->fax->country_code} {$contact->fax->area_code} {$contact->fax->call_number}</span></td></tr>";
            }

            $contactBlock[] = '</table>';

            $contactBlock[] = '</td>'; // ad__contact_person
        }
        $contactBlock[] = '</tr></table>';
    }
}

$descTable[] = '<table><tbody>';

if (isset($ad->dealer)) {
    $dealerStr = ($ad->dealer->city) ? "{$ad->dealer->zip} {$ad->dealer->city}" : $ad->dealer->name;
    $descTable[] = "<tr><td><b>Standort</b></td><td>$dealerStr</td></tr>";
}
$descTable[] = "<tr><td><b>".JText::_( 'COM_PIXELCMS_MANUFACTURER' )."</b></td><td>{$ad->manufacturer->value}</td></tr>";

if (isset($ad->condition)) $descTable[] = "<tr><td><b>".JText::_( 'COM_PIXELCMS_CONDITION' )."</b></td><td>" . JText::_( trim('COM_PIXELCMS_CONDITION_'.strtoupper($ad->condition->id)) ) . "</td></tr>";
if (isset($ad->year) && $ad->year) $descTable[] = "<tr><td><b>".JText::_( 'COM_PIXELCMS_BUILD_YEAR' )."</b></td><td>{$ad->year}</td></tr>";
if (isset($ad->workhours) && $ad->workhours->show) if ($ad->workhours && $ad->workhours->show) $descTable[] = "<tr><td><b>".JText::_( 'COM_PIXELCMS_WORKHOURS' )."</b></td><td>{$ad->workhours->show}</td></tr>";
if (isset($ad->power)) $descTable[] = "<tr><td><b>".JText::_( 'COM_PIXELCMS_POWER' )."</b></td><td>{$ad->power->kW} kW ({$ad->power->PS} PS)</td></tr>";
if (isset($ad->max_speed) && $ad->max_speed->show) $descTable[] = "<tr><td><b>{$ad->max_speed->name}</b></td><td>{$ad->max_speed->show}</td></tr>";
if (isset($ad->cylinders) && $ad->max_speed->value) $descTable[] = "<tr><td><b>{$ad->cylinders->name}</b></td><td>{$ad->cylinders->value}</td></tr>";
if (isset($ad->transmission) && $ad->transmission->show) $descTable[] = "<tr><td><b>{$ad->transmission->name}</b></td><td>{$ad->transmission->show}</td></tr>";
if (isset($ad->tyre_type)) $descTable[] = "<tr><td><b>".JText::_( 'COM_PIXELCMS_TYRE_TYPE' )."</b></td><td>{$ad->tyre_type}</td></tr>";
if (isset($ad->rim_diameter) && $ad->rim_diameter->value) $descTable[] = "<tr><td><b>{$ad->rim_diameter->name}</b></td><td>{$ad->rim_diameter->show}</td></tr>";
if (isset($ad->available) && $ad->available->value) $descTable[] = "<tr><td><b>{$ad->available->name}</b></td><td>{$ad->available->value}</td></tr>";
if (isset($ad->_3_point_hitch) && $ad->_3_point_hitch->show) $descTable[] = "<tr><td><b>{$ad->_3_point_hitch->name}</b></td><td>{$ad->_3_point_hitch->show}</td></tr>";

if ($ad->equipment) {
    $descTable[] = "<tr><td><b>".JText::_( 'COM_PIXELCMS_EQUIPMENT' )."</b></td><td><ul>";
    foreach ($ad->equipment as $key => $value) {
        $descTable[] = "<li>$value</li>";
    }
    $descTable[] = "</ul></td></tr>";
}

$descTable[] = '</tbody></table>';

if (isset ($ad->price) && isset ($ad->price->values) && $ad->price->values->netto > 0) {
    // $fmt = numfmt_create( 'de_DE', NumberFormatter::CURRENCY );
    $formatted_netto = number_format($ad->price->values->netto, 2, ',', '.');
    $formatted_brutto = number_format($ad->price->values->brutto, 2, ',', '.');

    if ($ad->offer) {
        $formatted_old = number_format($ad->price->values->old, 2, ',', '.');
        $nettoArr[] = "<del>$formatted_old {$ad->price->currency}</del>";
    }
    $nettoArr[] = "$formatted_netto {$ad->price->currency}";

    if (!$ad->vat->separable) {
        $priceBlock[] = implode(' ', $nettoArr);
        $priceBlock[] = '<div><small color="#888">' . JText::_( 'COM_PIXELCMS_VAT_NOT_SEPARABLE' ) . '</small></div>';
    } else {
        $priceBlock[] = JText::sprintf('COM_PIXELCMS_NETTO_SPRINTF', implode(' ', $nettoArr));
        if ($ad->vat->value) {
            $sprintf_suffix = ($ad->vat->value !== 0.19) ? '_SHOW_VAT' : '';
            $priceBlock[] = "<div><small color=\"#888\">".JText::sprintf( 'COM_PIXELCMS_BRUTTO_SPRINTF' . $sprintf_suffix, "$formatted_brutto {$ad->price->currency}", $ad->vat->value * 100 ). "</small></div>";
        }
    }
} else {
    $priceBlock[] = JText::_( 'COM_PIXELCMS_ASK_FOR_PRICE' );
}

?>
<style>
  td {
    padding: 8px;
  }
</style>
<table border="0" cellspacing="0" cellpadding="0">
  <tbody>
    <tr>
      <td width="40%" style="font-size: 0;">
        <table cellspacing="2" cellpadding="0">
          <tr><td colspan="3" style="font-size: 0;"><img src="<?= array_shift($images) ?>"></td></tr>
          <tr>
            <?= implode('',
                array_map(
                    function($img) { return "<td><img src=\"$img\"></td>"; },
                    array_splice($images, 0, 3)
                )) ?>
          </tr>
        </table>
      </td>
      <td width="10"></td>
      <td align="middle">
          <?= implode('', $descTable); ?>
      </td>
    </tr>
  </tbody>
</table>
<?php if ($ad->free_text): ?>
  <div>
    <h4>Beschreibung</h4>
    <hr>
    <p style="margin: 10px 0;"><?= nl2br($ad->free_text) ?></p>
  </div>
<?php endif ?>
<?php if ($this->params->get('show_contact', false) && $ad->contact_persons): ?>
  <div>
    <h4>Ansprechpartner</h4>
    <hr>
      <?= implode('', $contactBlock); ?>
  </div>
<?php endif ?>
<hr style="color: #ccc;">
<div style="text-align: right; font-size: 20px">
    <?= implode('', $priceBlock); ?>
</div>
