<?php
    $doc = JFactory::getDocument();

    JHtml::_('jquery.framework');

    $doc->addScript( JUri::base(true) . '/media/com_pixelcms_articles/js/jquery.colorbox-min.js' );
    $doc->addStyleSheet( JUri::base(true) . '/media/com_pixelcms_articles/css/colorbox.css' );

    $script = "
        jQuery( document ).ready(function() {
            jQuery('.gallery__body a.js-img').colorbox({
                rel:'gal',
                scrolling: false,
                maxHeight: '80%',
                maxWidth: '80%',
                fixed: true,
                className: 'droppics',
                title: function(){
                  const title = this.getAttribute('data-title');
                  if (title.match(/\.(jpe?g|png|svg)/)) return null;
                  return title || null;
                },
            });
        });
    ";
    $doc->addScriptDeclaration( $script );

    $showDescription = $this->params->get('show_gallery_desc', false);

    foreach ($this->gallery as $gallery) {
        $html[] = $this->displayGallery($gallery, $showDescription);
    }
    if (!$this->gallery) {
         $html[] = '&nbsp;'; // Fix empty joomla modules
    }

    if ($this->params->get('legacy_mode', '0') === '0') {
        $containerClass = $this->getContainerClass();
        $articleCount = count($this->gallery);
        array_unshift($html, "<div class=\"$containerClass\" data-count=\"$articleCount\">");
        array_push($html, '</div>');
    }
    if ($this->params->get('show_page_heading')) {
        array_unshift($html, "<div class=\"page-header\"><h2 itemprop=\"headline\">{$this->params->get('page_title')}</h2></div>");
    }

    echo implode("\n", $html);
