<?php
    $CMS_URL = 'https://cms.pixel-kraft.de';

    $thumbSize = $this->params->get('pixelcms_images_thumb_size', 500);

    foreach ($this->article as $article) {
        $classList['show_date'] = $this->params->get('show_date', '');

        $html[] = "<div class='cms_article {$this->compileClassList($classList)}'>";
        $link = JRoute::_("index.php?option=com_pixelcms_articles&view=pixelcms_articles&articleId=$article->id&Itemid=$this->item_id");
	    if ($article->titleimage) {
		    $thumb = $this->getThumbnail($article->titleimage, $thumbSize, false);
            if (in_array((int) $this->params->get('cut_images'), [1, 2])) {
                $html[] = "<a href='$link' class='cms_article__image' style='background-image: url({$this->params->get('pixel_cms_url')}/$thumb)'></a>";
            } else {
                $html[] = "<a href='$link' class='cms_article__image'><img src='{$this->params->get('pixel_cms_url')}/$thumb'></a>";
            }
        } else if ($article->images) {
		    $thumb = $this->getThumbnail($article->images[0], $thumbSize, false);
		    if (in_array((int) $this->params->get('cut_images'), [1, 2])) {
                $html[] = "<a href='$link' class='cms_article__image cms_article__image--article-image' style='background-image: url({$this->params->get('pixel_cms_url')}/$thumb)'></a>";
            } else {
                $html[] = "<a href='$link' class='cms_article__image cms_article__image--article-image'><img src='{$this->params->get('pixel_cms_url')}/$thumb'></a>";
            }
	    } else {
	        $html[] = "<div class='cms_article__image cms_article__image--empty'></div>";
        }
        $html[] = "<div class='cms_article__content'>";

        $date = "<span class='cms_article__date'>" . DateTime::createFromFormat('Y-m-d H:i:s', $article->created_at)->format('d.m.Y') . "</span>";

        if ($this->params->get('show_date', 0) === 'before') {
            $html[] = $date;
        }
        $html[] = "<a href='$link'><h2 class='cms_article__headline'>$article->title</h2></a>";
        if ($this->params->get('show_date', 0) === 'after') {
            $html[] = $date;
        }

        $intro_text = $this->getIntro($article->content, $this->params->get('intro_length'));

	    $html[] = "<div class='cms_article__intro'>$intro_text</div>";
        $html[] = "<a class=\"cms_article__readmore\" href=\"$link\">Weiterlesen</a>";
        $html[] = "</div>"; // cms_article__content
        $html[] = "</div>"; // cms_article
    }
    if (!$this->article) {
         $html[] = '&nbsp;'; // Fix empty joomla modules
    }

    if ($this->params->get('legacy_mode', '0') === '0') {
        $containerClass = $this->getContainerClass();
        $articleCount = count($this->article);
        array_unshift($html, "<div class=\"$containerClass\" data-count=\"$articleCount\">");
        array_push($html, '</div>');
    }
    if ($this->params->get('show_page_heading')) {
        array_unshift($html, "<div class=\"page-header\"><h2 itemprop=\"headline\">{$this->params->get('page_title')}</h2></div>");
    }

    if (isset($this->pagination) && $this->pagination->last_page != 1) {
        $paginator = $this->pagination;

        $html[] = '<ul class="pagination pg-blue">';

        $html[] = $this->paginationLink(1, $paginator->current_page == 1, '«');

        if ($paginator->current_page > 3) {
            $html[] = '<li class="page-item"><a class="page-link">...</a></li>';
        }

        for ($i = 1; $i <= $paginator->last_page; $i++) {
            if ( ($i > ($paginator->current_page - 3)) && ($i < ($paginator->current_page + 3)) ) {
                $html[] = $this->paginationLink($i, false, null, $paginator->current_page == $i);
            }
        }

        if ($paginator->current_page < ($paginator->last_page - 2)) {
            $html[] = '<li class="page-item"><a class="page-link">...</a></li>';
        }

        $html[] = $this->paginationLink($paginator->last_page, $paginator->current_page == $paginator->last_page, '»');
    }

    if ($this->params->get('is_module') && $this->params->get('show_archiv', true)) {
        $link = JRoute::_("index.php?Itemid=$this->item_id");
        $html[] = '<div class="clearfix"><a class="archive-link" href="' . $link . '">'. JText::_( 'COM_PIXELCMS_ARCHIVE' ) .'</a></div>';
    }


    echo implode("\n", $html);
