<?php
$doc = JFactory::getDocument();

JHtml::_('jquery.framework');

foreach ($this->gallery as $gallery) {
    $link = JRoute::_("index.php?option=com_pixelcms_articles&view=pixelcms_galleries&articleId=$gallery->id&Itemid=$this->item_id");
    $html[] = "<a class=\"gallery__item gallery__item--folder\" href=\"$link\">";
    $html[] = "<div class='gallery_folder'>";
    foreach (array_slice($gallery->images, 0, 6) as $image) {
        $thumb = $this->getThumbnail($image->url, 64);
        $html[] = "<span class='gallery_folder__thumbnail' style='background-image: url({$this->params->get('pixel_cms_url')}/$thumb)'></span>";
    }
    $html[] = '</div>';
    $html[] = "<span class='gallery_folder__title'>$gallery->title</span></a>";
}

if ($this->params->get('legacy_mode', '0') === '0') {
    $containerClass = $this->getContainerClass();
    $articleCount = count($this->gallery);
    array_unshift($html, "<div class=\"$containerClass\" data-count=\"$articleCount\">");
    array_push($html, '</div>');
}
if ($this->params->get('show_page_heading')) {
    array_unshift($html, "<div class=\"page-header\"><h2 itemprop=\"headline\">{$this->params->get('page_title')}</h2></div>");
}

echo implode("\n", $html);
