<?php
/**
 * @package    pixelcms_articles
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

defined('_JEXEC') or die;

/**
 * Pixelcms_articles view.
 *
 * @package  pixelcms_articles
 * @since    1.0
 */
class pixelcms_articlesViewlandwirt_content extends JViewLegacy
{
    public $item_id;
    protected $articleId;
    protected $customer;
    protected $module;
    protected $data;
    protected $params;

    public function __construct(array $config = array())
    {
        $jinput = JFactory::getApplication()->input;
        $this->articleId = $jinput->get('articleId', null);
        $this->customer = $jinput->getInt('landwirt_customer', null);
        $this->module = $jinput->get('landwirt_module', null);
        $this->item_id = $jinput->getInt('Itemid');
        parent::__construct($config);
    }

    protected function _setPath($type, $path)
    {
        $component = 'com_pixelcms_articles';
        $app = JFactory::getApplication();

        // Clear out the prior search dirs
        $this->_path[$type] = array();

        // Actually add the user-specified directories
        $this->_addPath($type, $path);

        // Always add the fallback directories as last resort
        switch (strtolower($type))
        {
            case 'template':
                // Set the alternative template search dir
                if (isset($app))
                {
                    $component = preg_replace('/[^A-Z0-9_\.-]/i', '', $component);
                    $fallback = JPATH_THEMES . '/' . $app->getTemplate() . '/html/' . $component . '/' . $this->getName();
                    $this->_addPath('template', $fallback);
                }
                break;
        }
    }

	function display($tpl = null)
	{
        $this->params = $this->get('state')->get('params');

        if ($this->articleId) {
            $this->module = ($this->module) ?: $this->params->get('landwirt_module');
        } else {
            $tpl = 'listing';
        }

        // Assign data to the view
        $this->data = $this->get($this->module);
//        $tpl .= $this->module;


        $document = JFactory::getDocument();
		$document->addStyleSheet(JURI::base(true) . '/media/com_pixelcms_articles/css/style.css', [
			'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/css/style.css'),
		]);
		$document->addScript(JURI::base(true) . '/media/com_pixelcms_articles/js/script.js', [
			'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/js/script.js'),
		]);

		// Display the view
		parent::display($tpl);
	}

    public function loadTemplate($tpl = null)
    {
        // Clear prior output
        $this->_output = null;

        $template = JFactory::getApplication()->getTemplate();
        $layout = $this->getLayout();
        $layoutTemplate = $this->getLayoutTemplate();

        // Create the template file name based on the layout
        $file = isset($tpl) ? $layout . '_' . $tpl : $layout;

        // Clean the file name
        $file = preg_replace('/[^A-Z0-9_\.-]/i', '', $file);
        $tpl = isset($tpl) ? preg_replace('/[^A-Z0-9_\.-]/i', '', $tpl) : $tpl;

        // Load the language file for the template
        $lang = JFactory::getLanguage();
        $lang->load('tpl_' . $template, JPATH_BASE, null, false, true)
        || $lang->load('tpl_' . $template, JPATH_THEMES . "/$template", null, false, true);

        // Change the template folder if alternative layout is in different template
        if (isset($layoutTemplate) && $layoutTemplate != '_' && $layoutTemplate != $template)
        {
            $this->_path['template'] = str_replace($template, $layoutTemplate, $this->_path['template']);
        }

        // Load the template script
        jimport('joomla.filesystem.path');
        $filetofind = $this->_createFileName('template', array('name' => $file));
        $this->_template = JPath::find($this->_path['template'], $filetofind);

        // If alternate layout can't be found, fall back to default layout
        if ($this->_template == false)
        {
            $filetofind = $this->_createFileName('', array('name' => 'default' . (isset($tpl) ? '_' . $tpl : $tpl)));
            $this->_template = JPath::find($this->_path['template'], $filetofind);
        }

        if ($this->_template != false)
        {
            // Unset so as not to introduce into template scope
            unset($tpl, $file);

            // Never allow a 'this' property
            if (isset($this->this))
            {
                unset($this->this);
            }

            // Start capturing output into a buffer
            ob_start();

            // Include the requested template filename in the local scope
            // (this will execute the view logic).
            include $this->_template;

            // Done with the requested template; get the buffer and
            // clear it.
            $this->_output = ob_get_contents();
            ob_end_clean();

            return $this->_output;
        }
        else
        {
            throw new Exception(JText::sprintf('JLIB_APPLICATION_ERROR_LAYOUTFILE_NOT_FOUND', $file), 500);
        }
    }
}
