<?php
/**
 * @package    pixelcms_articles
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */


use Joomla\Registry\Registry;

defined('_JEXEC') or die;

require_once 'BaseModel.php';

/**
 * Pixelcms_articles model.
 *
 * @package  pixelcms_articles
 * @since    1.0
 */
class Pixelcms_articlesModelPixelcms_manufacturers extends BaseModel
{
    protected $api_endpoint;
    protected $module;
    protected $articleId;
    protected $category_id;
    protected $linkIds;
    protected $cms_url;
    protected $alias;
    protected $filter;
    protected $api_version;

    protected $defaults = [
    	'limit' => 8,
    ];

    public function __construct(array $config = array())
    {
        $this->input = JFactory::getApplication()->input;

        parent::__construct($config);

        /** @var extendedRegistry $params - Settings for current Menu Item */
        $params = $this->getState('params');

        $this->category_id = $params->get('pixelcms_category_id', null);
        $this->articleId = $params->getInt('articleId', null);
        $this->cms_url = $params->get('pixel_cms_url');
        $this->linkIds = $params->get('m_ids', null);
        $this->api_version = $params->get('pixel_cms_version');
        $this->api_endpoint = 'manufacturers';
        $this->module = "pixelcms_manufacturers";
    }

    public function getManufacturers()
    {
        $data = $this->getCachedData();
        if ($this->articleId) {
            return array_reduce($data, function ($carry, $article) {
                if ($article->id === $this->articleId) {
                    $carry = $article;
                }
                return $carry;
            });
        }

        if ($this->linkIds) {
            return array_reduce($data, function($acc, $manufacturer)  {
                $filteredLinks = array_filter($manufacturer->links, function($link) {
                    return in_array($link->id, $this->linkIds);
                });

                if ($filteredLinks) {
                    $manufacturer->links = $filteredLinks;
                    array_push($acc, $manufacturer);
                }

                return $acc;
            }, []);
        }

        return $data;
    }

    public function getCachedData()
    {
    	$cacheKey = (is_array($this->category_id)) ? implode('.', $this->category_id) : $this->category_id;
        $articles = $this->cache->get($this->api_endpoint . $cacheKey, $this->module);

        if (empty($articles)) {
            $articles = $this->getData();
            $this->cache->store($articles, $this->api_endpoint . $cacheKey, $this->module);
        }

        return json_decode($articles);
    }

    private function getData()
    {
        $parameters = [];

        if ($this->category_id) {
            $parameters['category'] = $this->category_id;
        }

        $url = $this->cms_url . '/api/' . $this->api_version . '/' . "$this->api_endpoint";

        return $this->cURL($url, $parameters);
    }
}
