<?php
/**
 * @package    pixelcms_articles
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

use Joomla\CMS\MVC\View\HtmlView;

defined('_JEXEC') or die;

/**
 * Pixelcms_articles view.
 *
 * @package  pixelcms_articles
 * @since    1.0
 */
class Pixelcms_articlesViewPixelcms_galleries extends HtmlView
{
    public $item_id;
    public $gallery;
    public $cms_url;
    public $alias;
    protected $classSuffix = 'gallery__body';
    /**
     * @var extendedRegistry
     * @since version
     */
    public $params;
    public $options;
    public $hasVimeoPlayer = false;
    public $hasYoutubePlayer = false;
    public $hasFacebookPlayer = false;
    public $hasVideoPlayer = false;
    protected $is_module = false;

    protected function _setPath($type, $path)
    {
        $component = 'com_pixelcms_articles';
        $app = JFactory::getApplication();

        // Clear out the prior search dirs
        $this->_path[$type] = array();

        // Actually add the user-specified directories
        $this->_addPath($type, $path);

        // Always add the fallback directories as last resort
        switch (strtolower($type))
        {
            case 'template':
                // Set the alternative template search dir
                if (isset($app))
                {
                    $component = preg_replace('/[^A-Z0-9_\.-]/i', '', $component);
                    $fallback = JPATH_THEMES . '/' . $app->getTemplate() . '/html/' . $component . '/' . $this->getName();
                    $this->_addPath('template', $fallback);
                }
                break;
        }
    }

    public function compileClassList(array $classList): string
    {
        $classList = array_filter($classList);
        $classList = array_map(function($className, $classModifier) {
            return (is_numeric($className)) ? "cms_article--$classModifier" : "cms_article--$className-$classModifier";
            }, array_keys($classList), $classList);

        return implode(' ', $classList);
    }

	public function getThumbnail(string $url, int $size = 500, bool $cropped = true): string
	{
		return preg_replace('/^(?:\/)?((?!http)(?:(?!thumb).)*)\.(jpe?g|png|gif)/', ($cropped) ? "$1.$size-cropped.$2" : "$1.$size.$2", $url);
    }

    public function displayGallery($gallery)
    {
        $html = [];
        foreach ($gallery->images as $image) {
            $thumb = $this->getThumbnail($image->url);
	        $preview = $this->getThumbnail($image->url, 1600, false);
            $html[] = "<a class='js-img gallery__item gallery__item--image img' data-title='$image->title'  href='{$this->params->get('pixel_cms_url')}/$preview' style='background-image: url({$this->params->get('pixel_cms_url')}/$thumb)'></a>";
        }
        foreach ($gallery->videos as $video) {
            $html[] = "<div class='gallery__item gallery__item--video' style='background-image: url($video->thumb)'></div>";
        }
        return implode('', $html);
    }

    public function attachPlayerScripts()
    {
        if (!$this->hasVideoPlayer) {
            return "";
        }
        $html = [];
        $script = ['var play_class = "video--playing";'];
        if ($this->hasVimeoPlayer) {
            $html[] = "<script src='https://player.vimeo.com/api/player.js'></script>";
            $script[] = '
                [].slice.call(document.querySelectorAll(".vimeo_player")).forEach(function (el) {
                    var player = new Vimeo.Player(el);
                
                    player.on(\'play\', function () {
                        el.parentElement.classList.add(play_class);
                    });
                    player.on(\'pause\', function () {
                        el.parentElement.classList.remove(play_class);
                    });
                });
            ';
        }
        if ($this->hasYoutubePlayer) {
            $html[] = "<script src='https://www.youtube.com/iframe_api'></script>";
            $script[] = '
                function onYouTubeIframeAPIReady() {
                    [].slice.call(document.querySelectorAll(".youtube_player")).forEach(function (el) {
                        var player = new YT.Player(el, {
                            events: {
                                onStateChange: function onStateChange(event) {
                                    if (event.data === YT.PlayerState.PLAYING) {
                                        el.parentElement.classList.add(play_class);
                                    } else if (event.data === YT.PlayerState.PAUSED) {
                                        el.parentElement.classList.remove(play_class);
                                    }
                                }
                            }
                        });
                    });
                }
            ';
        }
        if ($this->hasFacebookPlayer) {
            $html[] = "<script src='https://connect.facebook.net/de_DE/sdk.js'></script>";
            $script[] = '
                function fbAsyncInit() {
                    FB.init({
                        appId      : \'922247001285262\',
                        xfbml      : true,
                        version    : \'v2.11\'
                    });

                    FB.Event.subscribe(\'xfbml.ready\', function(msg) {
                        console.log(msg.instance, msg);
                        if (msg.type === \'video\') {
                            msg.instance.subscribe(\'startedPlaying\', function(e) {
                                document.getElementById(msg.id).parentElement.classList.add(play_class);
                            });
                            msg.instance.subscribe(\'paused\', function(e) {
                                document.getElementById(msg.id).parentElement.classList.remove(play_class);
                            });
                            msg.instance.subscribe(\'finishedPlaying\', function(e) {
                                document.getElementById(msg.id).parentElement.classList.remove(play_class);
                            });
                        }
                    });
                };
            ';
        }
        $script = array_map(function($value) {
            return preg_replace('/[\s]{2,}/', '', $value);
        }, $script);
        $html[] = '<script>' . implode("", $script) . '</script>';
        return implode("\n", $html);
    }

    public function getContainerClass(): string
    {
        $viewName = $this->getName();

        $classList[] = "$viewName-wrapper";
        if ($this->params->get('is_module')) {
            $classList[] = 'mod_cms-wrapper';
            $classList[] = "$viewName-mod-wrapper";
        }
        $classList[] = $this->classSuffix;

        return implode(' ', $classList);
    }

	function display($tpl = null)
	{
		// Assign data to the view

        $this->gallery = $this->get('Gallery');

		$this->params = $this->get('state')->get('params');

        $tpl = ($this->params->has('articleId')) ? null : 'listing';

        $document = JFactory::getDocument();
        $document->addStyleSheet(JURI::base(true) . '/media/com_pixelcms_articles/css/fonts.css', [
            'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/css/fonts.css'),
        ]);
        $document->addStyleSheet(JURI::base(true) . '/media/com_pixelcms_articles/css/style.css', [
            'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/css/style.css'),
        ]);
        $document->addScript(JURI::base(true) . '/media/com_pixelcms_articles/js/script.js', [
            'version' => md5_file(JPATH_BASE . '/media/com_pixelcms_articles/js/script.js'),
        ]);

		// Display the view
		parent::display($tpl);
	}
}
